package com.zjty.inspect.enums;

import io.swagger.annotations.ApiModel;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@ApiModel(value = "浏览器插件")
@Getter
public enum  BrowserPlugEnum {
    NONE(-1,"无",0),
    DOWNLOAD(1,"下载/上传",0),
    PRINT(2,"打印调用",0),
    SCAN(3,"扫描调用",0),
    YIWEIMA(4,"一维码/二维码调用",0),
    OCR(5,"OCR调用：请在备注中填写插件名,如需填写多个,请以逗号分隔",1),
    MOBILE(6,"移动设备同步：请在备注中填写插件名,如需填写多个,请以逗号分隔",1),
    TEXT(7,"在线文本编辑类：请在备注中填写插件名,如需填写多个,请以逗号分隔",1),
    TABLE(8,"在线表单编辑类：请在备注中填写插件名,如需填写多个,请以逗号分隔",1),
    CHART(9,"在线统计图表展现类：请在备注中填写插件名,如需填写多个,请以逗号分隔",1),
    VIDEO(10,"在线视频播放类：请在备注中填写插件名,如需填写多个,请以逗号分隔",1),
    THREED(11,"在线3D建模、渲染、展现：请在备注中填写插件名,如需填写多个,请以逗号分隔",1),
    GIS(12,"在线GIS类：请在备注中填写插件名,如需填写多个,请以逗号分隔",1),
    PERIPHERAL(13,"外设调用",0),
    ANIMATION(14,"动画",0),
    FLASH(14,"Flash",0),
    OTHER(13,"其他：请在备注中填写插件名和版本,如需填写多个,请以逗号分隔",1);

    private Integer code;
    private String name;
    private Integer other;
    private static Map<String,BrowserPlugEnum> browserPlugEnumMap=new HashMap<>();
    private static Map<Integer,BrowserPlugEnum> browserPlugCodeEnumMap=new HashMap<>();

    static {
        for (BrowserPlugEnum browserPlugEnum : BrowserPlugEnum.values()) {
            browserPlugEnumMap.put(browserPlugEnum.getName(),browserPlugEnum);
            browserPlugCodeEnumMap.put(browserPlugEnum.getCode(),browserPlugEnum);
        }
    }
     BrowserPlugEnum() {
    }

     BrowserPlugEnum(Integer code, String name,Integer other) {
        this.code = code;
        this.name = name;
        this.other=other;
    }
    public static BrowserPlugEnum getByName(String name){
        BrowserPlugEnum browserPlugEnum = browserPlugEnumMap.get(name);
        if(browserPlugEnum==null){
            return NONE;
        }
        return browserPlugEnum;
    }
    public static BrowserPlugEnum getByCode(Integer code){
        BrowserPlugEnum browserPlugEnum = browserPlugCodeEnumMap.get(code);
        if(browserPlugEnum==null){
            return NONE;
        }
        return browserPlugEnum;
    }
}
