package com.zjty.inspect.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;
@Getter
public enum  OtherApiEnum {
    NONE(-1,"无",0),
    JNDI(0,"JNDI",0),
    ML(1,"其他命名与目录类API：请在备注中填写,如需填写多个,请以逗号分隔",1),
    JMS(2,"JMS",0),
    RestFul(3,"RestFul",0),
    XX(4,"其他消息类API：请在备注中填写,如需填写多个,请以逗号分隔",1),
    AMQP(5,"AMQP",0),
    KAFKA(6,"Kafka API",0),
    MQTT(7,"MQTT",0),
    ROUTE(8,"其他消息路由类API：请在备注中填写,如需填写多个,请以逗号分隔",1),
    ES(9,"ES",0),
    YQ(10,"其他搜索引擎类API：请在备注中填写,如需填写多个,请以逗号分隔",1),
    LOGSTASH(11,"Logstash",0),
    LOG(12,"其他分析日志类API：请在备注中填写,如需填写多个,请以逗号分隔",1),
    KIBANA(13,"Kibana",0),
    FXKS(14,"其他分析可视化类API：请在备注中填写,如需填写多个,请以逗号分隔",1),
    REDIS(15,"Redis",0),
    JIQ(16,"其他集群类API：请在备注中填写,如需填写多个,请以逗号分隔",1),
    ARCGIS(17,"ARCGIS",0),
    GIS(18,"其他GIS类API：请在备注中填写,如需填写多个,请以逗号分隔",1),
    EDIT(19,"在线编辑API：请在备注中填写,如需填写多个,请以逗号分隔",1),
    TUBIAO(20,"统计图表类API：请在备注中填写,如需填写多个,请以逗号分隔",1),
    BF(21,"播放类API：请在备注中填写,如需填写多个,请以逗号分隔",1),
    YJ(22,"硬件驱动类API：请在备注中填写,如需填写多个,请以逗号分隔",1),
    OCR(23,"OCR识别类API：请在备注中填写,如需填写多个,请以逗号分隔",1),
    JIAMI(24,"加密类API：请在备注中填写,如需填写多个,请以逗号分隔",1),
    OTHER(25,"其他：请在备注中填写,如需填写多个,请以逗号分隔",1);

    private Integer code;
    private String name;
    private Integer other;
    private static Map<String,OtherApiEnum> otherApiEnumMap=new HashMap<>();
    private static Map<Integer,OtherApiEnum> otherApiCodeEnumMap=new HashMap<>();

    static {
        for (OtherApiEnum otherApiEnum : OtherApiEnum.values()) {
            otherApiEnumMap.put(otherApiEnum.getName(),otherApiEnum);
        }
        for (OtherApiEnum otherApiEnum : OtherApiEnum.values()) {
            otherApiCodeEnumMap.put(otherApiEnum.getCode(),otherApiEnum);
        }
    }
    OtherApiEnum() {
    }

    OtherApiEnum(Integer code, String name,Integer other) {
        this.code = code;
        this.name = name;
    }
    public static OtherApiEnum getByName(String name){
        OtherApiEnum otherApiEnum = otherApiEnumMap.get(name);
        if(otherApiEnum==null){
            return NONE;
        }
        return otherApiEnum;
    }
    public static OtherApiEnum getByCode(Integer code){
        OtherApiEnum otherApiEnum = otherApiCodeEnumMap.get(code);
        if(otherApiEnum==null){
            return NONE;
        }
        return otherApiEnum;
    }
}
