package com.zjty.inspect.dao;

import com.zjty.inspect.entity.Technology;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;

import java.util.List;
import java.util.Optional;

public interface TechnologyDao extends JpaRepository<Technology,String>, JpaSpecificationExecutor<Technology> {

    /**
     * 根据名称查询适配技术
     * @param name 适配技术名称
     * @return Technology
     */
    Technology findAllByTechnologyNameEquals(String name);
    Optional<Technology> findById(String id);
    /**
     * 模糊查询技术名称
     * @param name
     * @return
     */
    List<Technology> findAllByTechnologyNameLike(String name);

    /**
     * 根据id查询
     * @param ids ids
     * @return
     */
    List<Technology> findAllByIdIn(List<String> ids);


    @Query("select technologyName from Technology ")
    List<String> getTechnologyNames();

    /**
     * 查询不支持的技术个数
     * @param support 是否支持
     * @return
     */
    int countAllBySupportIsNot(Integer support);

    /**
     * 查询前端或者后端依赖技术
     * @param backOrFront
     * @return
     */
    List<Technology> findAllByBackorfrontEquals(Integer backOrFront);
}
