package com.zjty.inspect.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import java.util.Date;

/**
 * @author Mcj
 * @date 2020-02-27 14:42
 */

@Data
@Entity
@ApiModel(value = "规则类")
public class RuleCollection {

    /**
     * 主键id
     */
    @Id
    @Column(length = 48)
    private String id;
    /**
     * 技术名称
     */
    private String technologyName;
    /**
     * 目标关键字
     */
    private String target;
    /**
     * 匹配的文件后缀
     */
    private String suffix;

    /**
     * 适配技术id
     */
    private String technologyId;
    /**
     * 数据创建时间
     */
    @Column(name="create_time",columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP",insertable = false,updatable = false)
    @CreatedDate
    private Date createDate;

    /**
     * 数据更新时间
     */
    @Column(name="update_time",columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP",insertable = false)
    @LastModifiedDate
    private Date updateDate;

}
