package com.zjty.inspect.controller;

import com.zjty.inspect.entity.Evaluation;
import com.zjty.inspect.entity.PageResult;
import com.zjty.inspect.entity.RuleQo;
import com.zjty.inspect.service.EvaluationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@RestController
@RequestMapping("/evaluation")
@Api(value = "评估报告管理接口",description = "评估报告管理接口,提供页面的增、删、改、查")
public class EvaluationController {
    @Autowired
    private EvaluationService evaluationService;

    /**
     * 新增评估报告
     * @param evaluation 评估报告
     * @return
     */
    @PostMapping
    @ApiOperation("新增评估报告")
    public ResponseEntity rule(@RequestBody Evaluation evaluation){
        evaluationService.save(evaluation);
        return ResponseEntity.ok(200);
    }
    @ApiOperation("根据用户名查询输出")
    @GetMapping(value = "/{name}")
    public ResponseEntity getName(@PathVariable String name) {
        Evaluation evaluation = evaluationService.findByName(name);
        return ResponseEntity.ok(evaluation.getOutEva());
    }
    @ApiOperation("根据用户名查询输如")
    @GetMapping(value = "/in/{name}")
    public ResponseEntity getInName(@PathVariable String name) {
        Evaluation evaluation = evaluationService.findByName(name);
        return ResponseEntity.ok(evaluation.getInEva());
    }
    /**
     * 修改评估报告
     * @param evaluation 规则封装
     * @param id id
     * @return
     */
    @PostMapping(value = "/{id}")
    @ApiOperation("修改评估报告")
    public ResponseEntity update(@RequestBody Evaluation evaluation,@PathVariable String id){
        evaluation.setId(id);
        evaluationService.update(evaluation);
        return ResponseEntity.ok(200);
    }
    /**
     * 根据id删除评估报告
     * @param id id
     * @return
     */
    @ApiOperation("根据id删除评估报告")
    @DeleteMapping(value = "/{id}")
    public ResponseEntity deleteById(@PathVariable String id){
        evaluationService.delete(id);
        return ResponseEntity.ok(200);
    }
    /**
     * 分页+多条件查询
     * @param searchMap 查询条件封装
     * @param page 页码
     * @param size 页大小
     * @return 分页结果
     */
    @ApiOperation("分页查询页面列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name="page",value = "页码",required=true,paramType="path",dataType="int"),
            @ApiImplicitParam(name="size",value = "每页记录数",required=true,paramType="path",dataType="int")
    })
    @RequestMapping(value="/search/{page}/{size}",method= RequestMethod.POST)
    public ResponseEntity findSearch(@RequestBody Map searchMap , @PathVariable int page, @PathVariable int size){
        Page<Evaluation> pageList = evaluationService.findSearch(searchMap, page, size);
        return  ResponseEntity.ok(new PageResult<Evaluation>(pageList.getTotalElements(), pageList.getContent()) );
    }


}
