package com.zjty.inspect.utils;

import com.zjty.inspect.entity.*;
import com.zjty.inspect.enums.CompatibleBrowser;
import com.zjty.inspect.enums.DatabaseType;
import com.zjty.inspect.enums.MiddlewareEnum;

import java.util.List;

/**
 * 应用系统改造替换工作量根据表单计算
 * @Author wyl
 * @Date 2020-03-6 14:20
 */
public class WorkLoadUtil {
    public double calculate(Reform reform){
        double score = 0;
        /**
         * 系统部署架构，其他需求，分布式、负载均衡、容灾每个+10
         */
        SystemStructure systemStructure = reform.getSystemStructure();
        //分布式
        if(systemStructure.getDistributed()==1){
            score+=10;
        }
        //负载均衡
        if(systemStructure.getLoadBalance()==1){
            score+=10;
        }
        //容灾
        if(systemStructure.getDisaster()==1){
            score+=10;
        }
        /**
         * 前端浏览器相关
         */
        Browser browser = reform.getBrowser();
        //如果原浏览器包含IE，+10
        if(browser.getCompatibleBrowsers().contains(CompatibleBrowser.IETRIDENT)){
            score+=10;
        }
        /*更多需求，每个+1*/
        //地理信息系统
        if(browser.getGeography()==1){
            score+=1;
        }
        //调用外设
        if(browser.getPeripheral()==1){
            score+=1;
        }
        //动画
        if(browser.getAnimation()==1){
            score+=1;
        }
        //3D展示
        if(browser.getThreeD()==1){
            score+=1;
        }
        //公文实现与编辑
        if(browser.getDocument()==1){
            score+=1;
        }
        //多媒体
        if(browser.getMedia()==1){
            score+=1;
        }
        //flash
        if(browser.getFlash()==1){
            score+=1;
        }
        //其他
        if(browser.getOtherDemand()==1){
            score+=1;
        }
        /**
         * 中间件，除Tomcat外每个+5;更多需求，每个+10
         */
        Middleware middleware = reform.getMiddleware();
        List<MiddlewareEnum> middlewareEnums = middleware.getMiddlewareEnums();
        int effectMidNum = middlewareEnums.size();
        if(middlewareEnums.contains(MiddlewareEnum.TOMCAT)){
            effectMidNum--;
        }
        if(middleware.getOtherMiddleware()!=null&&!middleware.getOtherMiddleware().trim().equals("")){
            effectMidNum++;
        }
        score+=effectMidNum*5;
        /*更多需求*/
        //Web集群
        if(middleware.getWeb()==1){
            score+=10;
        }
        //Jndi集群
        if(middleware.getJndi()==1){
            score+=10;
        }
        //Jms集群
        if(middleware.getJms()==1){
            score+=10;
        }
        //消息路由
        if(middleware.getRoute()==1){
            score+=10;
        }
        /**
         * 数据库相关，除mysql每个+10；小需求每个+2；更多需求每个+10
         */
        Database database = reform.getDatabase();
        List<DatabaseType> databaseType = database.getDatabaseType();
        int effectDatabaseNum = databaseType.size();
        if(databaseType.contains(DatabaseType.MYSQL)){
            effectDatabaseNum--;
        }
        if(database.getOtherType()!=null&&!database.getOtherType().trim().equals("")){
            effectDatabaseNum++;
        }
        score+=effectDatabaseNum*10;
        /*小需求，每个+2*/
        //视图
        if(database.getView()==1){
            score+=2;
        }
        //存储过程
        if(database.getStorage()==1){
            score+=2;
        }
        //函数
        if(database.getFunction()==1){
            score+=2;
        }
        //DbLink
        if(database.getDbLink()==1){
            score+=2;
        }
        //定时任务
        if(database.getTimeTask()==1){
            score+=2;
        }
        //序列
        if(database.getSequence()==1){
            score+=2;
        }
        //触发器
        if(database.getTrigger()==1){
            score+=2;
        }
        /*更多需求*/
        //容灾：2主备3分布式
        if(database.getDisasterTolerance()==2||database.getDisasterTolerance()==3){
            score+=10;
        }
        //安全
        if(database.getSafe()==1){
            score+=10;
        }
        //读写分离
        if(database.getSeparate()==1){
            score+=10;
        }
        //更高性能
        if(database.getPerformance()==1){
            score+=10;
        }
        //其他
        if(database.getOtherContent()!=null&&!database.getOtherContent().trim().equals((""))){
            score+=10;
        }
        /*迁移策略：平滑过渡+50%；短暂停顿+20%*/
        if(reform.getStrategy()==1){
            score+=score/2;
        }else if(reform.getStrategy()==2){
            score+=score/5;
        }
        return score;
    }
}
