package com.zjty.inspect.entity;

import com.zjty.inspect.enums.DatabaseType;
import com.zjty.inspect.task.task;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * <h4>Description : 数据库相关</h4>
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 * @Date : 2020-03-05 18:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Database {

    /**
     * 数据库类型 枚举
     */
    private List<DatabaseType> databaseType;

    /**
     * 其他
     */
    private String otherType;

    /**
     * 视图 int 1：是 2：否
     */
    private Integer view;
    /**
     * 存储过程 1：是 2：否
     */
    private Integer storage;

    /**
     * 函数 1：是 2：否
     */
    private Integer function = 1;

    /**
     * Dblink 1：是 2：否
     */
    private Integer dbLink;

    /**
     * 定时任务 1：是 2：否
     */
    private Integer timeTask = 1;

    /**
     * 序列 1：是 2：否
     */
    private Integer sequence = 1;

    /**
     * 触发器 1：是 2：否
     */
    private Integer trigger;

    /*
    更多内容
     */

    /**
     * 容灾 （1：否 2：主备 3：分布式）
     */
    private Integer disasterTolerance;

    /**
     * 安全 1：是 2：否
     */
    private Integer safe;

    /**
     * 读写分离 1：是 2：否
     */
    private Integer separate;

    /**
     * 更高性能 1：是 2：否
     */
    private Integer performance;

    /**
     * 其他内容
     */
    private String otherContent;
}
