package com.zjty.inspect.enums;


import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * <h4>Description : 操作系统</h4>
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 * @Date : 2020-03-05 17:03
 */
@Getter
public enum OperateSystem {

    WINDOWSXP10(1,"Windows（XP-Win10）"),
    WINDOWSSERVER200816(2,"WindowsServer（2008-2016）"),
    WINDOWSSERVER201620(3,"WindowsServer（2016-2020）"),
    REDHATORACLELINUX(4,"Redhat/OracleLinux系列"),
    CENTOS(5,"CentOS系列"),
    UBUNTU(6,"Ubuntu系列"),
    SUSE(7,"SUSE系列"),
    DEBIAN(8,"Debian系列"),
    FEDORA(9,"Fedora系列"),
    MAGEIA(10,"Mageia系例"),
    LEDE(11,"LEDE系列"),
    OPENWRT(12,"Openwrt GNU版本"),
    DEEPIN(13,"Deepin GNU版本"),
    UOS(14,"UOS GNU版本"),
    WINNINGKIRIN(15,"中标麒麟 GNU版本"),
    MILKYKIRIN(16,"银河麒麟 GNU版本"),
    ZHONGKEFANGDE(17,"中科方德 GNU版本"),
    XINZIDIAN(18,"新支点 GNU版本"),
    PUHUA(19,"普华 GNU版本"),
    APPLEUNIXGNU(20,"Apple-UnixGNU版本"),
    IBMAIX(21,"IBM-AIX系列"),
    HPUX(22,"HP-UX系列"),
    SUNSOLARIS(23,"SUN-Solaris系列"),
    MPISIRIX(24,"MPIS-Irix系列"),
    NONE(-1,"无");

    private Integer code;
    private String name;

    OperateSystem() {
    }
    private static Map<String, OperateSystem> operateSystemMap=new HashMap<>();
    private static Map<Integer, OperateSystem> operateSystemCodeMap=new HashMap<>();

    static {
        for (OperateSystem operateSystem : OperateSystem.values()) {
            operateSystemMap.put(operateSystem.getName(),operateSystem);
            operateSystemCodeMap.put(operateSystem.getCode(),operateSystem);
        }
    }
    OperateSystem(Integer code, String name) {
        this.code = code;
        this.name = name;
    }
    public static OperateSystem getByName(String name){
        OperateSystem operateSystem = operateSystemMap.get(name);
        if(operateSystem==null){
            return NONE;
        }
        return operateSystem;
    }
    public static OperateSystem getByCode(String name){
        OperateSystem operateSystem = operateSystemCodeMap.get(name);
        if(operateSystem==null){
            return NONE;
        }
        return operateSystem;
    }
}
