package com.zjty.inspect.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;
@Getter
public enum  OtherApiEnum {
    NONE(-1,"无"),
    JNDI(0,"JNDI"),
    ML(1,"其他命名与目录类API：请在备注中填写,如需填写多个,请以逗号分隔"),
    JMS(2,"JMS"),
    RestFul(3,"RestFul"),
    XX(4,"其他消息类API：请在备注中填写,如需填写多个,请以逗号分隔"),
    AMQP(5,"AMQP"),
    KAFKA(6,"Kafka API"),
    MQTT(7,"MQTT"),
    ROUTE(8,"其他消息路由类API：请在备注中填写,如需填写多个,请以逗号分隔"),
    ES(9,"ES"),
    YQ(10,"其他搜索引擎类API：请在备注中填写,如需填写多个,请以逗号分隔"),
    LOGSTASH(11,"Logstash"),
    LOG(12,"其他分析日志类API：请在备注中填写,如需填写多个,请以逗号分隔"),
    KIBANA(13,"Kibana"),
    FXKS(14,"其他分析可视化类API：请在备注中填写,如需填写多个,请以逗号分隔"),
    REDIS(15,"Redis"),
    JIQ(16,"其他集群类API：请在备注中填写,如需填写多个,请以逗号分隔"),
    ARCGIS(17,"ARCGIS"),
    GIS(18,"其他GIS类API：请在备注中填写,如需填写多个,请以逗号分隔"),
    EDIT(19,"在线编辑API：请在备注中填写,如需填写多个,请以逗号分隔"),
    TUBIAO(20,"统计图表类API：请在备注中填写,如需填写多个,请以逗号分隔"),
    BF(21,"播放类API：请在备注中填写,如需填写多个,请以逗号分隔"),
    YJ(22,"硬件驱动类API：请在备注中填写,如需填写多个,请以逗号分隔"),
    OCR(23,"OCR识别类API：请在备注中填写,如需填写多个,请以逗号分隔"),
    JIAMI(24,"加密类API：请在备注中填写,如需填写多个,请以逗号分隔"),
    OTHER(25,"其他：请在备注中填写,如需填写多个,请以逗号分隔");

    private Integer code;
    private String name;
    private static Map<String,OtherApiEnum> otherApiEnumMap=new HashMap<>();
    private static Map<Integer,OtherApiEnum> otherApiCodeEnumMap=new HashMap<>();

    static {
        for (OtherApiEnum otherApiEnum : OtherApiEnum.values()) {
            otherApiEnumMap.put(otherApiEnum.getName(),otherApiEnum);
        }
        for (OtherApiEnum otherApiEnum : OtherApiEnum.values()) {
            otherApiCodeEnumMap.put(otherApiEnum.getCode(),otherApiEnum);
        }
    }
    OtherApiEnum() {
    }

    OtherApiEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }
    public static OtherApiEnum getByName(String name){
        OtherApiEnum otherApiEnum = otherApiEnumMap.get(name);
        if(otherApiEnum==null){
            return NONE;
        }
        return otherApiEnum;
    }
    public static OtherApiEnum getByCode(Integer code){
        OtherApiEnum otherApiEnum = otherApiCodeEnumMap.get(code);
        if(otherApiEnum==null){
            return NONE;
        }
        return otherApiEnum;
    }
}
