package com.zjty.inspect.controller;

import com.zjty.inspect.dao.TechnologyDao;
import com.zjty.inspect.entity.*;
import com.zjty.inspect.service.InspectService;
import com.zjty.inspect.service.ParameterService;
import com.zjty.inspect.service.ReportService;
import com.zjty.inspect.service.TechnologyService;
import com.zjty.inspect.utils.*;
import freemarker.template.TemplateException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.apache.tomcat.util.http.fileupload.disk.DiskFileItem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import java.io.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 评估接口
 * @author mcj
 */
@Slf4j
@RestController
@RequestMapping("/inspect")
@Api(value = "评估接口管理接口",description = "评估管理接口,提供页面的增、删、改、查")
public class InspectController {
    @Autowired
    private InspectService inspectService;

    @Autowired
    private TechnologyService technologyService;

    @Autowired
    private ParameterService parameterService;

    @Autowired
    private ReportService reportService;
    /**
     * 上传代码进行评估
     * @param years      系统开发时间
     * @param systemFund    系统开发费用
     * @param modules   模块数
     * @param valid     预算数据是否可用
     * @param framework 架构
     * @param safety    安全能力
     * @param disaster  容灾能力
     * @param data  数据量
     * @param admin 是否管理员
     * @param multfile  文件
     * @return
     * @throws IOException
     */
    @PostMapping("/path")
    @ApiOperation("上传代码进行评估")
    public ResponseEntity inspect(Integer years,Integer systemFund,Integer modules
            ,String valid,Integer framework,Integer safety,Integer disaster,Integer data
            ,Integer admin,String projectName,Integer tables,String databaseType,Integer method,String username, MultipartFile multfile) throws IOException {

        File file = FileUtil.saveToLocal(multfile);
        log.info("inspect:代码解压完成,地址为{}",file.getCanonicalPath());
        InspectParameter inspectParameter = parameterService.getParameterByUsername(username);

        if(inspectParameter==null){
            inspectParameter = new InspectParameter();
            inspectParameter.setUsername(username);
            inspectParameter.setSystemFund(systemFund);
            inspectParameter.setModules(modules);
            inspectParameter.setSafety(safety);
            inspectParameter.setTables(tables);
            inspectParameter.setValid(valid);
            inspectParameter.setYears(years);
            inspectParameter.setDisaster(disaster);
            inspectParameter.setData(data);
            inspectParameter.setFramework(framework);
            inspectParameter.setId(UUIDUtil.getUUID());
            inspectParameter.setAdmin(admin);
        }
        inspectParameter.setRecastMethod(method);
        inspectParameter.setSourceAddress(file.getCanonicalPath());
        ReportVo reportVo = new ReportVo();
        int count = technologyService.findAllTechnologyCount();
        reportVo.setTechnologiesNum(count);
        int support = technologyService.findAllTechnologyNotSupport();
        reportVo.setTechnologiesRepair(support);

        reportVo.setId(RandomUtil.getRandom());
        reportVo.setUploadType("文件上传");
        reportVo.setFileName(file.getName());
        reportVo.setProjectName(projectName);
        reportVo.setSourceAddress(file.getCanonicalPath());
        reportVo.setDatabaseType(databaseType);
        //查找当前用户的参数是否存在
        ReportVo inspect = inspectService.inspect(reportVo,inspectParameter);
        log.info("inspect:代码评估完成");
        Map map=new HashMap();
        map.put("inspect",inspect);
        map.put("time",TimeUtil.getTime());
        HashMap<String, List<Warn>> warnMap = inspect.getWarnDetails();
        List<Technology> technologies = inspect.getTechnologies();
       Map techMap=new HashMap();
        for (Technology technology : technologies) {
            techMap.put(technology.getTechnologyName(),technology.getSupport());
        }
        map.put("techMap",techMap);
        map.put("warnMap",warnMap);
        map.put("technologies",technologies);
//        try {
//            String template = FreemarkerUtils.getTemplate("pg.ftl", map);
//            String s = inspectService.generateHtml(template, map);
//            String filePath = FileUtil.createFilePath();
//            File file1 = new File("./pgbg/" + filePath + "/" + file.getName() + ".html");
//            FileUtil.write(s,"./pgbg/"+filePath+"/"+file.getName()+".html");
//            reportVo.setHtmlAddress(file1.getCanonicalPath());
//            System.out.println("内容"+s);
//        } catch (TemplateException e) {
//            e.printStackTrace();
//        }
        Report report = new Report();
        String random = RandomUtil.getRandom();
        report.setId(RandomUtil.getRandom());
        report.setHtmlAddress(reportVo.getHtmlAddress());
        reportService.saveReport(report);
        inspectParameter.setReportId(random);
        parameterService.saveParameter(inspectParameter);
        return ResponseEntity.ok(inspect);
    }

    /**
     * git下载代码进行评估
     * @param inspectParameter 封装
     * @return
     */
    @PostMapping("/git")
    @ApiOperation("git下载代码进行评估")
    public ResponseEntity inspect1(@RequestBody InspectParameter inspectParameter){
        String path = GitLabUtil.downLoadProject(inspectParameter.getGitAddress(),inspectParameter.getGitName());
        inspectParameter.setId(UUIDUtil.getUUID());
        inspectParameter.setSourceAddress(path);
        ReportVo reportVo = new ReportVo();
        reportVo.setUploadType("git下载");
        reportVo.setSourceAddress(path);
        reportVo.setGitAddress(inspectParameter.getGitAddress());
        ReportVo inspect = inspectService.inspect(reportVo, inspectParameter);
        return ResponseEntity.ok(inspect);
    }
}
