package com.zjty.inspect.controller;

import com.alibaba.fastjson.JSON;
import com.zjty.inspect.dao.TechnologyDao;
import com.zjty.inspect.entity.*;
import com.zjty.inspect.service.InspectService;
import com.zjty.inspect.service.ParameterService;
import com.zjty.inspect.service.ReportService;
import com.zjty.inspect.service.TechnologyService;
import com.zjty.inspect.utils.*;
import freemarker.template.TemplateException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.apache.tomcat.util.http.fileupload.disk.DiskFileItem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import java.io.*;
import java.util.*;

/**
 * 评估接口
 *
 * @author mcj
 */
@Slf4j
@RestController
@RequestMapping("/inspect")
@Api(value = "评估接口管理接口", description = "评估管理接口,提供页面的增、删、改、查")
public class InspectController {
    @Autowired
    private InspectService inspectService;

    @Autowired
    private TechnologyService technologyService;

    @Autowired
    private ParameterService parameterService;

    @Autowired
    private ReportService reportService;

    /**
     * 上传代码进行评估
     *
     * @param years      系统开发时间
     * @param systemFund 系统开发费用
     * @param modules    模块数
     * @param valid      预算数据是否可用
     * @param framework  架构
     * @param safety     安全能力
     * @param disaster   容灾能力
     * @param data       数据量
     * @param admin      是否管理员
     * @param multfile   文件
     * @return
     * @throws IOException
     */
    @PostMapping("/path")
    @ApiOperation("上传代码进行评估")
    public ResponseEntity inspect(Integer years, Integer systemFund, Integer modules
            , String valid, Integer framework, Integer safety, Integer disaster, Integer data
            , Integer admin, String projectName, Integer tables, String databaseType, Integer method, String username, MultipartFile multfile) throws IOException {

        File file = FileUtil.saveToLocal(multfile);
        log.info("inspect:代码解压完成,地址为{}", file.getCanonicalPath());
        InspectParameter inspectParameter = new InspectParameter();

        inspectParameter.setUsername(username);
        inspectParameter.setSystemFund(systemFund);
        inspectParameter.setModules(modules);
        inspectParameter.setSafety(safety);
        inspectParameter.setTables(tables);
        inspectParameter.setValid(valid);
        inspectParameter.setYears(years);
        inspectParameter.setDisaster(disaster);
        inspectParameter.setData(data);
        inspectParameter.setFramework(framework);
        inspectParameter.setId(UUIDUtil.getUUID());
        inspectParameter.setAdmin(admin);
        inspectParameter.setSystemFund(systemFund);
        inspectParameter.setRecastMethod(method);
        inspectParameter.setSourceAddress(file.getCanonicalPath());
        ReportVo reportVo = new ReportVo();

        reportVo.setId(RandomUtil.getRandom());
        reportVo.setUploadType("文件上传");
        reportVo.setFileName(file.getName());
        reportVo.setProjectName(projectName);
        reportVo.setSourceAddress(file.getCanonicalPath());
        reportVo.setDatabaseType(databaseType);
        ReportVo inspect = inspectService.inspect(reportVo, inspectParameter);

        int count = technologyService.findAllTechnologyCount();
        reportVo.setTechnologiesNum(count);
        int support = technologyService.findAllTechnologyNotSupport();
        reportVo.setTechnologiesRepair(support);
        log.info("inspect:代码评估完成");
//        Map map = new HashMap();
//        map.put("inspect", inspect);
//        map.put("time", TimeUtil.getTime());
//        HashMap<String, List<Warn>> warnMap = inspect.getWarnDetails();
//        List<Technology> technologies = inspect.getTechnologies();
//        Map techMap = new HashMap();
//        for (Technology technology : technologies) {
//            techMap.put(technology.getTechnologyName(), technology.getSupport());
//        }
//        map.put("techMap", techMap);
//        map.put("warnMap", warnMap);
//        map.put("technologies", technologies);
//        try {
//            String template = FreemarkerUtils.getTemplate("pg.ftl", map);
//            String s = inspectService.generateHtml(template, map);
//            String filePath = FileUtil.createFilePath();
//            File file1 = new File("./pgbg/" + filePath + "/" + file.getName() + ".html");
//            FileUtil.write(s,"./pgbg/"+filePath+"/"+file.getName()+".html");
//            reportVo.setHtmlAddress(file1.getCanonicalPath());
//            System.out.println("内容"+s);
//        } catch (TemplateException e) {
//            e.printStackTrace();
//        }
        Report report = new Report();
        String random = RandomUtil.getRandom();
        report.setId(RandomUtil.getRandom());
        report.setHtmlAddress(reportVo.getHtmlAddress());
        reportService.saveReport(report);
        return ResponseEntity.ok(inspect);
    }

    /**
     * git下载代码进行评估
     *
     * @param inspectParameter 封装
     * @return
     */
    @PostMapping("/git")
    @ApiOperation("git下载代码进行评估")
    public ResponseEntity inspect1(@RequestBody InspectParameter inspectParameter) {
        String path = GitLabUtil.downLoadProject(inspectParameter.getGitAddress(), inspectParameter.getGitName());
        inspectParameter.setId(UUIDUtil.getUUID());
        inspectParameter.setSourceAddress(path);
        ReportVo reportVo = new ReportVo();
        reportVo.setUploadType("git下载");
        reportVo.setSourceAddress(path);
        reportVo.setGitAddress(inspectParameter.getGitAddress());
        ReportVo inspect = inspectService.inspect(reportVo, inspectParameter);
        return ResponseEntity.ok(inspect);
    }

    @PostMapping("/frontend")
    @ApiOperation("git下载代码进行评估")
    public ResponseEntity inspect(MultipartFile file) throws IOException {

        return ResponseEntity.ok(200);
    }

    @PostMapping("/rapidAssessment")
    public ResponseEntity rapidAssessment(@RequestBody Reform reform){
        //File file = FileUtil.saveToLocal(multfile);
        InspectParameter inspectParameter = new InspectParameter();
        inspectParameter.setSourceAddress(reform.getCodeUrl());
        inspectParameter.setSystemFund(reform.getCost());
        inspectParameter.setAdmin(reform.getAdmin());
        inspectParameter.setModules(reform.getModuleNum());
        inspectParameter.setSafety(reform.getSafe());
        inspectParameter.setTables(reform.getTableNum());
//        inspectParameter.setValid(valid);
//        inspectParameter.setYears(years);
        inspectParameter.setDisaster(reform.getDisasterTolerance());
        inspectParameter.setData(reform.getDatabaseNum());
        inspectParameter.setFramework(reform.getFramework());
        inspectParameter.setPath(reform.getGitUrl());
        inspectParameter.setRecastMethod(reform.getMode());
        inspectParameter.setId(UUIDUtil.getUUID());
        ReportVo reportVo = new ReportVo();

        int count = technologyService.findAllTechnologyCount();
        reportVo.setTechnologiesNum(count);
        int support = technologyService.findAllTechnologyNotSupport();
        reportVo.setTechnologiesRepair(support);

        reportVo.setId(RandomUtil.getRandom());
        reportVo.setUploadType("文件上传");
        reportVo.setFileName(reform.getCodeName());
        reportVo.setProjectName(reform.getProjectName());
        reportVo.setSourceAddress(reform.getCodeUrl());
        reportVo.setDatabaseType(null);

        ReportVo inspect = inspectService.inspect(reportVo,inspectParameter);

        Map map=new HashMap();
        map.put("inspect",inspect);
        map.put("time",TimeUtil.getTime());
        HashMap<String, List<Warn>> warnMap = inspect.getWarnDetails();
        List<Technology> technologies = inspect.getTechnologies();
        Map techMap=new HashMap();
        for (Technology technology : technologies) {
            techMap.put(technology.getTechnologyName(),technology.getSupport());
        }
        map.put("techMap",techMap);
        map.put("warnMap",warnMap);
        map.put("technologies",technologies);
        try {
            String template = FreemarkerUtils.getTemplate("pg.ftl", map);
            String s = inspectService.generateHtml(template, map);
            String filePath = FileUtil.createFilePath();
            File file1 = new File("./pgbg/" + filePath + "/" + reform.getCodeName() + ".html");
            FileUtil.write(s,"./pgbg/"+filePath+"/"+reform.getCodeName()+".html");
            reportVo.setHtmlAddress(file1.getCanonicalPath());
            System.out.println("内容"+s);
        } catch (Exception e) {
            e.printStackTrace();
        }
        Report report = new Report();
        String random = RandomUtil.getRandom();
        report.setId(RandomUtil.getRandom());
        report.setHtmlAddress(reportVo.getHtmlAddress());
        reportService.saveReport(report);
        inspectParameter.setReportId(random);
        parameterService.saveParameter(inspectParameter);
        /*
        马晨俊运算结束
         */
        System.out.println(JSON.toJSONString(inspect));
        /*
        将马晨俊的数据放入输出的表单
         */
        AssessmentReport assessmentReport = new AssessmentReport();
        //系统名称
        assessmentReport.setSysName(inspect.getProjectName());
        //软件名称
        assessmentReport.setOrgName(inspect.getFileName());
        //评估时间
        assessmentReport.setTime(inspect.getCreateDate());
        //适配预算
        assessmentReport.setBudget(inspect.getBudgets().getBudget().get(0).getFund());
        //原系统规模，马晨俊没放进去
        //技术详情，马晨俊的警告点,同时统计技术的数量
        //样式调整
        int css = 0;
        //API数量
        int api = 0;
        //插件替换数量
        int plugIn = 0;
        HashMap<String, List<Warn>> warnDetails = inspect.getWarnDetails();
        Set<String> keySet = warnDetails.keySet();
        List<TechnologyReport> technologyReports = new ArrayList<>();
        for (String key:keySet) {
            List<Warn> warns = warnDetails.get(key);
            if(warns.size()>0){
                TechnologyReport technologyReport = new TechnologyReport();
                technologyReport.setTechnology(key);
                //少一个策略
                List<TechnologyContent> technologyContents = new ArrayList<>();
                for (Warn warn:warns) {
                    TechnologyContent technologyContent = new TechnologyContent();
                    technologyContent.setFile(warn.getFilePath());
                    technologyContent.setKeyWord(warn.getRule());
                    technologyContent.setPosition(warn.getLineNum().toString());
                    technologyContents.add(technologyContent);
                }
                if(Objects.equals(key, "Microsoft CSS extensions(不支持)")){
                    css = technologyContents.size();
                }else if(Objects.equals(key, "Microsoft API extensions(不支持)")){
                    api = technologyContents.size();
                }else if(Objects.equals(key, "Microsoft JavaScript extensions(不支持)")){
                    plugIn = technologyContents.size();
                }
                technologyReport.setTechnologyContents(technologyContents);
                technologyReports.add(technologyReport);
            }
        }
        TechnologyList technologyList = new TechnologyList();
        technologyList.setDes(null);
        technologyList.setTechnologyReports(technologyReports);
        assessmentReport.setTechnologyList(technologyList);
        //额外申请
        assessmentReport.setApply(reform.getApply());

        //难度数据填写
        DifficultyAssessment difficultyAssessment = new DifficultyAssessment();
        //系统部署架构难度,reform中获取,少一个前后端分离
        FrameDifficulty frameDifficulty = new FrameDifficulty();
        SystemStructure systemStructure = reform.getSystemStructure();
        frameDifficulty.setDisaster(systemStructure.getDisaster());
        frameDifficulty.setDistributed(systemStructure.getDistributed());
        frameDifficulty.setLoadBalance(systemStructure.getLoadBalance());
        frameDifficulty.setOtherDemand(systemStructure.getOtherDemand());

        //浏览器难度
        BrowserDifficulty browserDifficulty = new BrowserDifficulty();
        browserDifficulty.setApi(api);
        browserDifficulty.setStyle(css);
        browserDifficulty.setPlugInUnit(plugIn);
        Browser browser = reform.getBrowser();
        browserDifficulty.setOtherDemand(browser.getOtherDemand());
        browserDifficulty.setGeography(browser.getGeography());
        browserDifficulty.setPeripheral(browser.getPeripheral());
        browserDifficulty.setAnimation(browser.getAnimation());
        browserDifficulty.setThreeD(browser.getThreeD());
        browserDifficulty.setDocument(browser.getDocument());
        browserDifficulty.setMedia(browser.getMedia());
        browserDifficulty.setFlash(browser.getFlash());

        return ResponseEntity.ok(new AssessmentReport());
    }



}
