package com.zjty.inspect.entity;

import lombok.Data;

import javax.persistence.Entity;
import javax.persistence.Id;

/**
 * 系数计算
 *
 * @author Mcj
 */

@Entity
@Data
public class CoefficientModel {

    @Id
    private String id;

    /**
     * 评定名称
     */
    private String name;

    /**
     * 大规模系数 0.1
     */
    private Double topCoefficient;
    /**
     * 中等规模系数 0
     */
    private Double mediumCoefficient;
    /**
     * 小规模系数 -0.1
     */
    private Double belowCoefficient;

    /**
     * 最小值4
     */
    private Integer min;

    private Integer max;

    private Integer scale;

    public Double countCoefficient(Integer data) {
        if(data==null){
            return 1D;
        }
        if(data<min){
            return 1+belowCoefficient;
        }else if(data>max){
            return 1+topCoefficient;
        }else {
            return 1+mediumCoefficient;
        }
    }
}
