package com.zjty.inspect.enums;

import io.swagger.annotations.ApiModel;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@ApiModel(value = "主开发架构")
@Getter
public enum  FrameWorkEnum {
    WU(-1,"无"),
    NET(1,".NET体系下的框架"),
    JEE(2,"J2EE体系下的框架"),
    PHP(3,"ThinkPHP"),
    YII(4,"Yii"),
    CODEIGNITER(5,"CodeIgniter"),
    LARAVEL(6,"Laravel"),
    DJANGO(7,"Django"),
    TORNADO(8,"Tornado"),
    FLASK(9,"Flask"),
    TWISTED(10,"Twisted"),
    SCRAPY(11,"Scrapy"),
    BOTTLE(12,"Bottle"),
    WEBPY(13,"Webpy"),
    FALCON(14,"Falcon"),
    QITA(15,"其他：请在备注中填写,如需填写多个,请以逗号分隔");

    private Integer code;
    private String name;
    FrameWorkEnum() {
    }
    private static Map<String,FrameWorkEnum> frameWorkEnumMap=new HashMap<>();
    private static Map<Integer,FrameWorkEnum> frameWorkEnumCodeMap=new HashMap<>();

    static {
        for (FrameWorkEnum frameWorkEnum : FrameWorkEnum.values()) {
            frameWorkEnumMap.put(frameWorkEnum.getName(),frameWorkEnum);
            frameWorkEnumCodeMap.put(frameWorkEnum.getCode(),frameWorkEnum);
        }
    }
    FrameWorkEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public static FrameWorkEnum getByName(String name){
        FrameWorkEnum frameWorkEnum = frameWorkEnumMap.get(name);
        return frameWorkEnum;
    }
    public static FrameWorkEnum getByCode(Integer code){
        FrameWorkEnum frameWorkEnum = frameWorkEnumCodeMap.get(code);
        return frameWorkEnum;
    }
}
