package com.zjty.inspect.enums;

import io.swagger.annotations.ApiModel;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@ApiModel(value = "其他开发语言")
@Getter
public enum  LanguageEnum {
    WU(-1,"无"),
    C(1,"VC/C++/C#"),
    VB(2,"VB"),
    DELPHI(3,"Delphi"),
    PHP(4,"PHP"),
    JAVA(5,"JAVA"),
    PYTHON(6,"Python"),
    GO(7,"Go"),
    RUST(8,"Rust"),
    RUBY(9,"Ruby"),
    PERL(10,"Perl"),
    MATLAB(11,"Matlab"),
    QITA(12,"其他：请在备注中填写,如需填写多个,请以逗号分隔");


    private Integer code;
    private String name;

    LanguageEnum() {
    }
    private static Map<String,LanguageEnum> languageEnumMap=new HashMap<>();
    private static Map<Integer,LanguageEnum> languageEnumCodeMap=new HashMap<>();


    static {
        for (LanguageEnum languageEnum : LanguageEnum.values()) {
            languageEnumMap.put(languageEnum.getName(),languageEnum);
            languageEnumCodeMap.put(languageEnum.getCode(),languageEnum);
        }
    }
    LanguageEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public static LanguageEnum getByName(String name){
        LanguageEnum languageEnum = languageEnumMap.get(name);
        return languageEnum;
    }
    public static LanguageEnum getByCode(Integer code){
        LanguageEnum languageEnum = languageEnumCodeMap.get(code);
        return languageEnum;
    }
}
