package com.zjty.inspect.dao;


import com.zjty.inspect.entity.Rule;
import org.springframework.data.jpa.repository.JpaRepository;

import java.util.List;

public interface RuleDao extends JpaRepository<Rule,String> {
    /**
     * 根据目标关键字查询规则
     * @param target 目标关键字
     * @return
     */
    Rule findAllByTargetEquals(String target);

    /**
     * 根据目标关键字查询规则
     * @param target 目标关键字
     * @param techId 关键技术id
     * @return
     */
    Rule findAllByTargetEqualsAndTechnologyIdEquals(String target,String techId);

    List<Rule> findAllByTargetLike(String target);
}
