package com.zjty.inspect.entity;

import lombok.Data;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import java.sql.Timestamp;

/**
 * 建议
 * @author Mcj
 * @date 2020-02-26 14:18
 */

@Entity
@Data
public class Technology {

    @Id
    @Column( length = 48)
    private String id;

    /**
     * 技术名称
     */
    private String technologyName;

    /**
     * 技术建议
     */
    private String advice;

    /**
     * 金额(万元)
     */
    private Integer fund;

    /**
     * 1：支持
     * 2：不支持
     * 3：未知
     */
    private Integer support;

    /**
     * 技术类型
     */
    private String backOrFront;
    /**
     * 数据创建时间
     */
    @Column(name="create_time",columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP",insertable = false,updatable = false)
    @Generated(GenerationTime.INSERT)
    private Timestamp createDate;

    /**
     * 数据更新时间
     */
    @Column(name="update_time",columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP",insertable = false)
    @Generated(GenerationTime.ALWAYS)
    private Timestamp updateDate;
}
