package com.zjty.inspect.controller;

import com.zjty.inspect.service.ReportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Mcj
 * @date 2020-03-05 19:22
 */

@RestController
@RequestMapping("/report")
@Api(value = "报告管理页面接口",description = "报告管理页面接口,提供页面的增、删、改、查")
public class ReportController {

    @Autowired
    private ReportService reportService;

    @GetMapping("/page/{page}")
    @ApiOperation("根据页码获取数据")
    public ResponseEntity getReportByPage(@PathVariable int page){
        return ResponseEntity.ok(reportService.findReportByPage(page));
    }

    @GetMapping("/id/{id}")
    @ApiOperation("根据id获取数据")
    public ResponseEntity getReportById(@PathVariable String id){
        return ResponseEntity.ok(reportService.findReportById(id));
    }
}
