package com.zjty.inspect.controller;

import com.zjty.inspect.entity.RuleQo;
import com.zjty.inspect.service.RuleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * 规则库设置
 * @author Mcj
 * @date 2020-02-26 14:42
 */

@RestController
@RequestMapping("/rule")
public class RuleController {

    @Autowired
    private RuleService ruleService;

    /**
     * 新增规则
     * @param ruleQo 规则封装
     * @return
     */
    @PostMapping
    public ResponseEntity rule(@RequestBody RuleQo ruleQo){
        ruleService.addRule(ruleQo);
        return ResponseEntity.ok(200);
    }
    /**
     * 修改规则
     * @param ruleQo 规则封装
     * @param id id
     * @return
     */
    @PostMapping(value = "/{id}")
    public ResponseEntity update(@RequestBody RuleQo ruleQo,@PathVariable String id){
        ruleQo.setId(id);
        ruleService.upRule(ruleQo);
        return ResponseEntity.ok(200);
    }
    /**
     * 根据id删除规则
     * @param id id
     * @return
     */
    @DeleteMapping(value = "/{id}")
    public ResponseEntity deleteById(@PathVariable String id){
        ruleService.deleteById(id);
        return ResponseEntity.ok(200);
    }
    /**
     * 查询所有规则
     * @return 规则
     */
    @GetMapping
    public ResponseEntity getRules(){
        return ResponseEntity.ok(ruleService.findAll());
    }
}
