package com.zjty.inspect.service.impl;

import com.zjty.inspect.dao.ParameterDao;
import com.zjty.inspect.entity.InspectParameter;
import com.zjty.inspect.service.ParameterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 参数
 * @author Mcj
 * @date 2020-02-27 21:36
 */

@Service
@Transactional(rollbackFor = Exception.class)
public class ParameterServiceImpl implements ParameterService {

    @Autowired
    private ParameterDao parameterDao;

    @Override
    public void saveParameter(InspectParameter inspectParameter) {
        parameterDao.save(inspectParameter);
    }

    @Override
    public InspectParameter getParameterById(String id) {
        if(parameterDao.findById(id).isPresent()){
            return parameterDao.findById(id).get();
        }
        return new InspectParameter();
    }
}
