package com.zjty.inspect.entity;

import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import java.sql.Timestamp;
import java.util.Date;

@Entity
@NoArgsConstructor
@AllArgsConstructor
@Data
@ApiModel(description = "评估报告管理类")
public class Evaluation {
    @Id
    @Column( length = 48)
    private String id;
    private String username;
    private Integer authority;
    private String projectName;
    @Column(columnDefinition = "TEXT")
    private String inEva;
    @Column(columnDefinition = "TEXT")
    private String outEva;
    /**
     * 数据创建时间
     */
    @Column(name="create_time",columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP",insertable = false,updatable = false)
    @CreatedDate
    private Date createDate;

    /**
     * 数据更新时间
     */
    @Column(name="update_time",columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP",insertable = false)
    @LastModifiedDate
    private Date updateDate;
}
