package com.zjty.inspect.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.Id;
import java.util.ArrayList;
import java.util.List;

/**
 * 传入参数，需要保存
 * @author Mcj
 * @date 2020-02-12 12:35
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
public class InspectParameter {

    @Id
    private String id;

    /**
     *  重构占比
     */
    private String proportion;

    /**
     * 年利率
     */
    private String moneyRate;

    /**
     * 原系统费用
     */
    private Integer systemFund;

    /**
     * 模块数
     */
    private Integer modules;

    /**
     * 每页预算
     */
    private Integer pageBudget;


}
