package com.zjty.inspect.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zjty.inspect.utils.Inspector;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

import javax.persistence.*;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

/**
 * 报告
 * @author mcj
 */
@Entity
@Data
@NoArgsConstructor
@AllArgsConstructor
public class Report {

    /**
     * 主键id uuid
     */
    @Id
    @Column(length = 48)
    private String id;

    /**
     * git源代码地址
     */
    private String gitAddress;

    /**
     * 架构，整合型还是分离型，根据jsp数量决定
     */
    private String framework;

    /**
     * 代码管理方式，
     */
    private String manager;

    /**
     * 语言
     */
    private String language;

    /**
     * 生成报告存储地址
     */
    private String htmlAddress;

    /**
     * 适配方式
     * 1：适配
     * 2：重构
     */
    @Column(length = 5)
    private Integer recastMethod;

    /**
     * 总资金(万元)
     */
    @Column(length = 10)
    private Integer fund;

    /**
     * 数据创建时间
     */
    @Column(name="create_time",columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP",insertable = false,updatable = false)
    @Generated(GenerationTime.INSERT)
    private Timestamp createDate;

    /**
     * 数据更新时间
     */
    @Column(name="update_time",columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP",insertable = false)
    @Generated(GenerationTime.ALWAYS)
    private Timestamp updateDate;

    public enum DependenceManagement{
        MAVEN,GRADLE,ANT
    }
    public enum Language{
        JAVA,PYTHON,CPP,JSP,ASP,ONLYVIEW,UNKNOW,JAVASCRIPT,GO,VUE
    }
}
