package com.zjty.inspect.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * 系数计算
 *
 * @author Mcj
 */
@Table(name = "master_coefficient_model")
@Entity
@Data
@ApiModel(value = "系数计算")
public class CoefficientModel {

    @Id
    private String id;

    /**
     * 评定名称
     */
    private String name;

    /**
     * 大规模系数 0.1
     */
    private Double topCoefficient;
    /**
     * 中等规模系数 0
     */
    private Double mediumCoefficient;
    /**
     * 小规模系数 -0.1
     */
    private Double belowCoefficient;

    /**
     * 最小值4
     */
    @ApiModelProperty(value = "最小值4",example = "4")
    private Integer min;
    @ApiModelProperty(value = "最大值4",example = "4")
    private Integer max;
    @ApiModelProperty(value = "scale",example = "4")
    private Integer scale;

    public Double countCoefficient(Integer data) {
        if(data==null || data<0){
            return 1D;
        }
        if(data<min){
            return 1+belowCoefficient;
        }else if(data>max){
            return 1+topCoefficient;
        }else {
            return 1+mediumCoefficient;
        }
    }
}
