package com.zjty.inspect.enums;

import io.swagger.annotations.ApiModel;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@ApiModel(value = "微服务")
@Getter
public enum MicroServiceEnum {
    NONE(-1,"无"),
    FLUME(0,"Flume"),
    ZOOKEEPER(1,"Zookeeper"),
    RIBBON(2,"Ribbon"),
    HYSTIX(3,"Hystix"),
    HBASE(4,"HBASE"),
    HIVE(5,"Hive"),
    SPARKSTROM(6,"Spark Strom"),
    RESTTEMPLATE(7,"RestTemplate"),
    KVM(8,"KVM"),
    OPENSTACK(9,"Openstack"),
    KUBERNETES(10,"Kubernetes"),
    DOCKER(11,"Docker"),
    EXMOBI(12,"Exmobi"),
    DATAV(13,"DataV"),
    RAYDATA(14,"RayData"),
    BIANMU(15,"编目服务：请在备注中填写,如需填写多个,请以逗号分隔"),
    DITU(16,"地图类微服务：请在备注中填写,如需填写多个,请以逗号分隔"),
    TUBIAO(17,"图表视图类微服务：请在备注中填写,如需填写多个,请以逗号分隔"),
    SHIBIE(18,"识别类微服务：请在备注中填写"),
    NEIRONG(19,"内容审查类微服务：请在备注中填写,如需填写多个,请以逗号分隔"),
    FENXI(20,"智能分析类微服务：请在备注中填写,如需填写多个,请以逗号分隔"),
    DATA(21,"数据引用类微服务：请在备注中填写,如需填写多个,请以逗号分隔"),
    IOQUICK(22,"流媒体加速类微服务：请在备注中填写,如需填写多个,请以逗号分隔"),
    JIAMI(23,"加密类微服务：请在备注中填写,如需填写多个,请以逗号分隔"),
    OTHER(24,"其他：请在备注中填写,如需填写多个,请以逗号分隔");
    private Integer code;
    private String name;

    MicroServiceEnum() {
    }
    private static Map<String,MicroServiceEnum> microServiceEnumMap=new HashMap<>();
    static {
        for (MicroServiceEnum microServiceEnum : MicroServiceEnum.values()) {
            microServiceEnumMap.put(microServiceEnum.getName(),microServiceEnum);
        }
    }
    MicroServiceEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }
    public static MicroServiceEnum getByName(String name){
        MicroServiceEnum microServiceEnum = microServiceEnumMap.get(name);
        if(microServiceEnum == null){
            return NONE;
        }
        return microServiceEnum;
    }
}
