package com.zjty.inspect.utils;

import com.zjty.inspect.entity.DocumentContent;
import com.zjty.inspect.entity.DocumentPage;
import com.zjty.inspect.entity.TechnologyContent;
import com.zjty.inspect.entity.TitleHead;
import com.zjty.inspect.enums.DocumentTitleEnum;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.regex.Matcher;

/**
 *  String tableString = DocumentWordUtil.getTableString(strs, 3);
 *         DocumentPage documentPage=new DocumentPage();
 *         documentPage.setHeader("随便写个主标题");
 *         List<TitleHead> titleHeads=new ArrayList<>();
 *         TitleHead titleHead=new TitleHead();
 *         titleHead.setName("随便写个副标题");
 *         titleHead.setParentId(3);
 *         List<DocumentContent> documentContents=new ArrayList<>();
 *         DocumentContent content=new DocumentContent();
 *         content.setDocumentTable(tableString);
 *         content.setContent("近代工商企业竞争日益剧烈，商品与商品之间，常有剧烈的商业竞争。为了确保产质量量符合标准，进而提高产质量，除对制造技术不断研究改进外，工厂操作的严格管制尤为重要。通常在管制技术上有二个要求，一个是如何保持各种操作条件，及产质量量合乎规定的限度，另一个是如何减少损耗，提高效率。鼎新质量管理系统乃是以统计数理分析为基础，应用在公司生产过程中，采购进货，生产入库，及托外进货的质量检验，其配合公司使用人员，管理人员的知识及经验，以数理的分析与客观的判断，谋求操作标准化，来提高生产效率及降低成本。");
 *         DocumentContent content1=new DocumentContent();
 *         content1.setContent("质量管理系统透过弹性参数设置，以符合不同行业，不同生产型态之品管要求，并与采购系统，工令/托外管理系统，应收 /应付管理系统搭配，以求达到全面整合的架构，且利用图形报表产出提供相关质量分析报表以提供质量改善参考，并以达到高质量要求为目标，让企业能在竞争激烈的环境中脱颖而出。");
 *         documentContents.add(content);
 *         documentContents.add(content1);
 *         titleHead.setDocumentContents(documentContents);
 *         titleHeads.add(titleHead);
 *         documentPage.setTitleHeads(titleHeads);
 *         String document = documentService.createDocument(documentPage);
 *         FreeMakerUtils.writeFile("E:/doc/text.doc",document);
 */
public class DocumentWordUtil {
    public static String Maintitle(){
        return "<w:p>\n" +
                "                <w:pPr>\n" +
                "                    <w:pStyle w:val=\"2\"/>\n" +
                "                    <w:jc w:val=\"center\"/>\n" +
                "                    <w:rPr>\n" +
                "                        <w:rFonts w:hint=\"fareast\"/>\n" +
                "                        <w:lang w:val=\"EN-US\" w:fareast=\"ZH-CN\"/>\n" +
                "                    </w:rPr>\n" +
                "                </w:pPr>\n" +
                "                <w:r>\n" +
                "                    <w:rPr>\n" +
                "                        <w:rFonts w:hint=\"fareast\"/>\n" +
                "                        <w:lang w:val=\"EN-US\" w:fareast=\"ZH-CN\"/>\n" +
                "                    </w:rPr>\n" +
                "                    <w:t>#title#</w:t>\n" +
                "                </w:r>\n" +
                "            </w:p>";

    }
    public static String subheading(DocumentTitleEnum documentTitleEnum){

        return "<w:p>\n" +
                "                <w:pPr>\n" +
                "                    <w:pStyle w:val=\""+documentTitleEnum.getStyle()+"\"/>\n" +
                "<w:listPr>\n" +
                "                        <w:ilvl w:val=\""+documentTitleEnum.getIlvl()+"\"/>\n" +
                "                        <w:ilfo w:val=\""+documentTitleEnum.getIlfo()+"\"/>\n" +
                "                    </w:listPr>" +
                "                    <w:rPr>\n" +
                "                        <w:rFonts w:hint=\"default\"/>\n" +
                "                        <w:lang w:val=\"EN-US\" w:fareast=\"ZH-CN\"/>\n" +
                "                    </w:rPr>\n" +
                "                </w:pPr>\n" +
                "                <w:r>\n" +
                "                    <w:rPr>\n" +
                "                        <w:rFonts w:hint=\"fareast\"/>\n" +
                "                        <w:lang w:val=\"EN-US\" w:fareast=\"ZH-CN\"/>\n" +
                "                    </w:rPr>\n" +
                "                    <w:t>#title#</w:t>\n" +
                "                </w:r>\n" +
                "            </w:p>";
    }

    public static String content(){
        return  "<w:p>\n" +
                "                <w:pPr>\n" +
                "                    <w:ind w:first-line=\"420\" w:first-line-chars=\"0\"/>\n" +
                "                    <w:rPr>\n" +
                "                        <w:rFonts w:hint=\"fareast\"/>\n" +
                "                        <w:lang w:val=\"EN-US\" w:fareast=\"ZH-CN\"/>\n" +
                "                    </w:rPr>\n" +
                "                </w:pPr>\n" +
                "                <w:r>\n" +
                "                    <w:rPr>\n" +
                "                        <w:rFonts w:hint=\"fareast\"/>\n" +
                "                        <w:lang w:val=\"EN-US\" w:fareast=\"ZH-CN\"/>\n" +
                "                    </w:rPr>\n" +
                "                    <w:t>#content#</w:t>\n" +
                "                </w:r>\n" +
                "            </w:p>";
    }


    public static String getTableString(List<TechnologyContent> tables,  String technologyName, String stra){
        //key 表格标题，value 内容
        String s3 = tableTile(technologyName, stra);
        String s4 = Matcher.quoteReplacement(s3);
        StringBuilder sb=new StringBuilder();
        sb.append(s4);
        for (int j = 0; j < tables.size(); j++) {
            String gettb = gettb(tables.get(j));
            String s1 = Matcher.quoteReplacement(gettb);
            sb.append(s1);
        }
        sb.append("</w:tbl>");
        return sb.toString();
    }

    public static String gettb(TechnologyContent technologyContent){
        StringBuilder sb=new StringBuilder();
        String biaoge = biaoge(technologyContent);
        sb.append(biaoge);
        return sb.toString();
    }

    public static String tabtb(){
        return "<w:tc>\n" +
                "                        <w:tcPr>\n" +
                "                            <w:tcW w:w=\"#colW#\" w:type=\"dxa\"/>\n" +
                "                            <w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"auto\"/>\n" +
                "                        </w:tcPr>\n" +
                "                        <w:p>\n" +
                "                            <w:pPr>\n" +
                "                                <w:widowControl w:val=\"off\"/>\n" +
                "                                <w:jc w:val=\"both\"/>\n" +
                "                                <w:rPr>\n" +
                "                                    <w:rFonts w:hint=\"default\"/>\n" +
                "                                    <w:vertAlign w:val=\"baseline\"/>\n" +
                "                                    <w:lang w:val=\"EN-US\" w:fareast=\"ZH-CN\"/>\n" +
                "                                </w:rPr>\n" +
                "                            </w:pPr>\n" +
                "                            <w:r>\n" +
                "                                <w:rPr>\n" +
                "                                    <w:rFonts w:hint=\"fareast\"/>\n" +
                "                                    <w:vertAlign w:val=\"baseline\"/>\n" +
                "                                    <w:lang w:val=\"EN-US\" w:fareast=\"ZH-CN\"/>\n" +
                "                                </w:rPr>\n" +
                "                                <w:t>#target#</w:t>\n" +
                "                            </w:r>\n" +
                "                        </w:p>\n" +
                "                    </w:tc>";
    }
    public static String tabtr(){
        return "<w:tc>\n" +
                "                        <w:tcPr>\n" +
                "                            <w:tcW w:w=\"#colW#\" w:type=\"dxa\"/>\n" +
                "                            <w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"auto\"/>\n" +
                "                        </w:tcPr>\n" +
                "                        <w:p>\n" +
                "                            <w:pPr>\n" +
                "                                <w:widowControl w:val=\"off\"/>\n" +
                "                                <w:jc w:val=\"both\"/>\n" +
                "                                <w:rPr>\n" +
                "                                    <w:rFonts w:hint=\"default\"/>\n" +
                "                                    <w:vertAlign w:val=\"baseline\"/>\n" +
                "                                    <w:lang w:val=\"EN-US\" w:fareast=\"ZH-CN\"/>\n" +
                "                                </w:rPr>\n" +
                "                            </w:pPr>\n" +
                "                            <w:r>\n" +
                "                                <w:rPr>\n" +
                "                                    <w:rFonts w:hint=\"fareast\"/>\n" +
                "                                    <w:vertAlign w:val=\"baseline\"/>\n" +
                "                                    <w:lang w:val=\"EN-US\" w:fareast=\"ZH-CN\"/>\n" +
                "                                </w:rPr>\n" +
                "                                <w:t>关键字</w:t>\n" +
                "                            </w:r>\n" +
                "                        </w:p>\n" +
                "                    </w:tc>";

    }

    public static String tr(){
        return "<w:tr>\n" +
                "                                <w:tblPrEx>\n" +
                "                                    <w:tblBorders>\n" +
                "                                        <w:top w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                                        <w:left\n" +
                "                                                w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                                        <w:bottom w:val=\"single\" w:sz=\"4\"\n" +
                "                                                  wx:bdrwidth=\"10\" w:space=\"0\"\n" +
                "                                                  w:color=\"auto\"/>\n" +
                "                                        <w:right\n" +
                "                                                w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                                        <w:insideH w:val=\"single\" w:sz=\"4\"\n" +
                "                                                   wx:bdrwidth=\"10\" w:space=\"0\"\n" +
                "                                                   w:color=\"auto\"/>\n" +
                "                                        <w:insideV\n" +
                "                                                w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                                    </w:tblBorders>\n" +
                "                                    <w:tblCellMar>\n" +
                "                                        <w:top w:w=\"0\" w:type=\"dxa\"/>\n" +
                "                                        <w:left w:w=\"108\" w:type=\"dxa\"/>\n" +
                "                                        <w:bottom w:w=\"0\" w:type=\"dxa\"/>\n" +
                "                                        <w:right w:w=\"108\" w:type=\"dxa\"/>\n" +
                "                                    </w:tblCellMar>\n" +
                "                                </w:tblPrEx>\n" +
                "                                <w:trPr>\n" +
                "                                    <w:trHeight w:val=\"400\" w:h-rule=\"atLeast\"/>\n" +
                "                                </w:trPr>";
    }
    public static String standtab(){
        return "<w:tbl>\n" +
                "                <w:tblPr>\n" +
                "                    <w:tblStyle w:val=\"a9\"/>\n" +
                "                    <w:tblW w:w=\"8818\" w:type=\"dxa\"/>\n" +
                "                    <w:tblInd w:w=\"0\" w:type=\"dxa\"/>\n" +
                "                    <w:tblBorders>\n" +
                "                        <w:top w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                        <w:left w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                        <w:bottom w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                        <w:right w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                        <w:insideH w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                        <w:insideV w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                    </w:tblBorders>\n" +
                "                    <w:tblCellMar>\n" +
                "                        <w:top w:w=\"0\" w:type=\"dxa\"/>\n" +
                "                        <w:left w:w=\"108\" w:type=\"dxa\"/>\n" +
                "                        <w:bottom w:w=\"0\" w:type=\"dxa\"/>\n" +
                "                        <w:right w:w=\"108\" w:type=\"dxa\"/>\n" +
                "                    </w:tblCellMar>\n" +
                "                </w:tblPr>\n" +
                "                <w:tblGrid>\n" +
                "                    <w:gridCol w:w=\"2371\"/>\n" +
                "                    <w:gridCol w:w=\"4440\"/>\n" +
                "                    <w:gridCol w:w=\"2007\"/>\n" +
                "                </w:tblGrid>\n" +
                "                <w:tr>\n" +
                "                    <w:tblPrEx>\n" +
                "                        <w:tblBorders>\n" +
                "                            <w:top w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                            <w:left w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                            <w:bottom w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                            <w:right w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                            <w:insideH w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                            <w:insideV w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                        </w:tblBorders>\n" +
                "                        <w:tblCellMar>\n" +
                "                            <w:top w:w=\"0\" w:type=\"dxa\"/>\n" +
                "                            <w:left w:w=\"108\" w:type=\"dxa\"/>\n" +
                "                            <w:bottom w:w=\"0\" w:type=\"dxa\"/>\n" +
                "                            <w:right w:w=\"108\" w:type=\"dxa\"/>\n" +
                "                        </w:tblCellMar>\n" +
                "                    </w:tblPrEx>\n" +
                "                    <w:trPr>\n" +
                "                        <w:trHeight w:val=\"388\" w:h-rule=\"atLeast\"/>\n" +
                "                    </w:trPr>\n" +
                "                    #tc1#\n" +
                "                </w:tr>\n" +
                "                    #tb1#\n" +
                "                </w:tr>\n" +
                "            </w:tbl>";
    }

    public static void yem(){
        String str="<w:sectPr>\n" +
                "                <w:hdr w:type=\"odd\">\n" +
                "                    <w:p>\n" +
                "                        <w:pPr>\n" +
                "                            <w:pStyle w:val=\"a7\"/>\n" +
                "                        </w:pPr>\n" +
                "                        <w:r>\n" +
                "                            <w:rPr>\n" +
                "                                <w:sz w:val=\"18\"/>\n" +
                "                            </w:rPr>\n" +
                "                            <w:pict>\n" +
                "                                <v:group id=\"组合 5\" o:spid=\"_x0000_s1026\" o:spt=\"203\"\n" +
                "                                         style=\"position:absolute;left:0pt;margin-left:0pt;margin-top:0pt;height:23.85pt;width:596.1pt;mso-position-horizontal-relative:page;mso-position-vertical-relative:page;z-index:251658240;mso-width-relative:margin;mso-height-relative:page;\"\n" +
                "                                         coordorigin=\"2107,1246\" coordsize=\"8306,477\">\n" +
                "                                    <o:lock v:ext=\"edit\" aspectratio=\"f\"/>\n" +
                "                                    <v:shape id=\"文本框 2\" o:spid=\"_x0000_s1027\" o:spt=\"202\" type=\"#_x0000_t202\"\n" +
                "                                             style=\"position:absolute;left:2107;top:1246;height:477;width:1388;\"\n" +
                "                                             filled=\"f\" stroked=\"f\" coordsize=\"21600,21600\">\n" +
                "                                        <v:path/>\n" +
                "                                        <v:fill on=\"f\" focussize=\"0,0\"/>\n" +
                "                                        <v:stroke on=\"f\" weight=\"0.5pt\"/>\n" +
                "                                        <v:imagedata o:title=\"\"/>\n" +
                "                                        <o:lock v:ext=\"edit\" aspectratio=\"f\"/>\n" +
                "                                        <v:textbox>\n" +
                "                                            <w:txbxContent>\n" +
                "                                                <w:p>\n" +
                "                                                    <w:pPr>\n" +
                "                                                        <w:rPr>\n" +
                "                                                            <w:rFonts w:ascii=\"汉仪雅酷黑 75W\" w:h-ansi=\"汉仪雅酷黑 75W\"\n" +
                "                                                                      w:fareast=\"汉仪雅酷黑 75W\" w:cs=\"汉仪雅酷黑 75W\"\n" +
                "                                                                      w:hint=\"fareast\"/>\n" +
                "                                                            <w:lang w:val=\"EN-US\" w:fareast=\"ZH-CN\"/>\n" +
                "                                                        </w:rPr>\n" +
                "                                                    </w:pPr>\n" +
                "                                                    <w:r>\n" +
                "                                                        <w:rPr>\n" +
                "                                                            <w:rFonts w:ascii=\"汉仪雅酷黑 75W\" w:h-ansi=\"汉仪雅酷黑 75W\"\n" +
                "                                                                      w:fareast=\"汉仪雅酷黑 75W\" w:cs=\"汉仪雅酷黑 75W\"\n" +
                "                                                                      w:hint=\"fareast\"/>\n" +
                "                                                            <w:lang w:val=\"EN-US\" w:fareast=\"ZH-CN\"/>\n" +
                "                                                        </w:rPr>\n" +
                "                                                        <w:t>工作项目</w:t>\n" +
                "                                                    </w:r>\n" +
                "                                                </w:p>\n" +
                "                                            </w:txbxContent>\n" +
                "                                        </v:textbox>\n" +
                "                                    </v:shape>\n" +
                "                                    <v:shape id=\"文本框 3\" o:spid=\"_x0000_s1028\" o:spt=\"202\" type=\"#_x0000_t202\"\n" +
                "                                             style=\"position:absolute;left:5566;top:1246;height:477;width:1388;\"\n" +
                "                                             filled=\"f\" stroked=\"f\" coordsize=\"21600,21600\">\n" +
                "                                        <v:path/>\n" +
                "                                        <v:fill on=\"f\" focussize=\"0,0\"/>\n" +
                "                                        <v:stroke on=\"f\" weight=\"0.5pt\"/>\n" +
                "                                        <v:imagedata o:title=\"\"/>\n" +
                "                                        <o:lock v:ext=\"edit\" aspectratio=\"f\"/>\n" +
                "                                        <v:textbox>\n" +
                "                                            <w:txbxContent>\n" +
                "                                                <w:p>\n" +
                "                                                    <w:pPr>\n" +
                "                                                        <w:jc w:val=\"center\"/>\n" +
                "                                                        <w:rPr>\n" +
                "                                                            <w:rFonts w:ascii=\"汉仪雅酷黑 75W\" w:h-ansi=\"汉仪雅酷黑 75W\"\n" +
                "                                                                      w:fareast=\"汉仪雅酷黑 75W\" w:cs=\"汉仪雅酷黑 75W\"\n" +
                "                                                                      w:hint=\"fareast\"/>\n" +
                "                                                            <w:lang w:val=\"EN-US\" w:fareast=\"ZH-CN\"/>\n" +
                "                                                        </w:rPr>\n" +
                "                                                    </w:pPr>\n" +
                "                                                    <w:r>\n" +
                "                                                        <w:rPr>\n" +
                "                                                            <w:rFonts w:ascii=\"汉仪雅酷黑 75W\" w:h-ansi=\"汉仪雅酷黑 75W\"\n" +
                "                                                                      w:fareast=\"汉仪雅酷黑 75W\" w:cs=\"汉仪雅酷黑 75W\"\n" +
                "                                                                      w:hint=\"fareast\"/>\n" +
                "                                                            <w:lang w:val=\"EN-US\" w:fareast=\"ZH-CN\"/>\n" +
                "                                                        </w:rPr>\n" +
                "                                                        <w:t>工作内容</w:t>\n" +
                "                                                    </w:r>\n" +
                "                                                </w:p>\n" +
                "                                            </w:txbxContent>\n" +
                "                                        </v:textbox>\n" +
                "                                    </v:shape>\n" +
                "                                    <v:shape id=\"文本框 4\" o:spid=\"_x0000_s1029\" o:spt=\"202\" type=\"#_x0000_t202\"\n" +
                "                                             style=\"position:absolute;left:9025;top:1246;height:477;width:1388;\"\n" +
                "                                             filled=\"f\" stroked=\"f\" coordsize=\"21600,21600\">\n" +
                "                                        <v:path/>\n" +
                "                                        <v:fill on=\"f\" focussize=\"0,0\"/>\n" +
                "                                        <v:stroke on=\"f\" weight=\"0.5pt\"/>\n" +
                "                                        <v:imagedata o:title=\"\"/>\n" +
                "                                        <o:lock v:ext=\"edit\" aspectratio=\"f\"/>\n" +
                "                                        <v:textbox>\n" +
                "                                            <w:txbxContent>\n" +
                "                                                <w:p>\n" +
                "                                                    <w:pPr>\n" +
                "                                                        <w:jc w:val=\"right\"/>\n" +
                "                                                        <w:rPr>\n" +
                "                                                            <w:rFonts w:ascii=\"汉仪雅酷黑 75W\" w:h-ansi=\"汉仪雅酷黑 75W\"\n" +
                "                                                                      w:fareast=\"汉仪雅酷黑 75W\" w:cs=\"汉仪雅酷黑 75W\"\n" +
                "                                                                      w:hint=\"default\"/>\n" +
                "                                                            <w:lang w:val=\"EN-US\" w:fareast=\"ZH-CN\"/>\n" +
                "                                                        </w:rPr>\n" +
                "                                                    </w:pPr>\n" +
                "                                                    <w:r>\n" +
                "                                                        <w:rPr>\n" +
                "                                                            <w:rFonts w:ascii=\"汉仪雅酷黑 75W\" w:h-ansi=\"汉仪雅酷黑 75W\"\n" +
                "                                                                      w:fareast=\"汉仪雅酷黑 75W\" w:cs=\"汉仪雅酷黑 75W\"\n" +
                "                                                                      w:hint=\"fareast\"/>\n" +
                "                                                            <w:lang w:val=\"EN-US\" w:fareast=\"ZH-CN\"/>\n" +
                "                                                        </w:rPr>\n" +
                "                                                        <w:t>公司名称</w:t>\n" +
                "                                                    </w:r>\n" +
                "                                                </w:p>\n" +
                "                                            </w:txbxContent>\n" +
                "                                        </v:textbox>\n" +
                "                                    </v:shape>\n" +
                "                                    <v:line id=\"直接连接符 1\" o:spid=\"_x0000_s1030\" o:spt=\"20\"\n" +
                "                                            style=\"position:absolute;left:2107;top:1723;height:0;width:8305;\" filled=\"f\"\n" +
                "                                            stroked=\"t\" coordsize=\"21600,21600\">\n" +
                "                                        <v:path arrowok=\"t\"/>\n" +
                "                                        <v:fill on=\"f\" focussize=\"0,0\"/>\n" +
                "                                        <v:stroke color=\"#000000\" joinstyle=\"round\"/>\n" +
                "                                        <v:imagedata o:title=\"\"/>\n" +
                "                                        <o:lock v:ext=\"edit\" aspectratio=\"f\"/>\n" +
                "                                    </v:line>\n" +
                "                                </v:group>\n" +
                "                            </w:pict>\n" +
                "                        </w:r>\n" +
                "                    </w:p>\n" +
                "                </w:hdr>\n" +
                "                <w:ftr w:type=\"odd\">\n" +
                "                    <w:p>\n" +
                "                        <w:pPr>\n" +
                "                            <w:pStyle w:val=\"a6\"/>\n" +
                "                        </w:pPr>\n" +
                "                        <w:r>\n" +
                "                            <w:rPr>\n" +
                "                                <w:sz w:val=\"18\"/>\n" +
                "                            </w:rPr>\n" +
                "                            <w:pict>\n" +
                "                                <v:shape id=\"_x0000_s1031\" o:spt=\"202\" type=\"#_x0000_t202\"\n" +
                "                                         style=\"position:absolute;left:0pt;margin-top:0pt;height:144pt;width:144pt;mso-position-horizontal:center;mso-position-horizontal-relative:margin;mso-wrap-style:none;z-index:251659264;mso-width-relative:page;mso-height-relative:page;\"\n" +
                "                                         filled=\"f\" stroked=\"f\" coordsize=\"21600,21600\">\n" +
                "                                    <v:path/>\n" +
                "                                    <v:fill on=\"f\" focussize=\"0,0\"/>\n" +
                "                                    <v:stroke on=\"f\"/>\n" +
                "                                    <v:imagedata o:title=\"\"/>\n" +
                "                                    <o:lock v:ext=\"edit\" aspectratio=\"f\"/>\n" +
                "                                    <v:textbox inset=\"0.00pt,0.00pt,0.00pt,0.00pt\" style=\"mso-fit-shape-to-text:t;\">\n" +
                "                                        <w:txbxContent>\n" +
                "                                            <w:p>\n" +
                "                                                <w:pPr>\n" +
                "                                                    <w:pStyle w:val=\"a6\"/>\n" +
                "                                                    <w:rPr>\n" +
                "                                                        <w:rFonts w:fareast=\"宋体\" w:hint=\"fareast\"/>\n" +
                "                                                        <w:lang w:fareast=\"ZH-CN\"/>\n" +
                "                                                    </w:rPr>\n" +
                "                                                </w:pPr>\n" +
                "                                                <w:r>\n" +
                "                                                    <w:rPr>\n" +
                "                                                        <w:rFonts w:hint=\"fareast\"/>\n" +
                "                                                        <w:lang w:fareast=\"ZH-CN\"/>\n" +
                "                                                    </w:rPr>\n" +
                "                                                    <w:fldChar w:fldCharType=\"begin\"/>\n" +
                "                                                </w:r>\n" +
                "                                                <w:r>\n" +
                "                                                    <w:rPr>\n" +
                "                                                        <w:rFonts w:hint=\"fareast\"/>\n" +
                "                                                        <w:lang w:fareast=\"ZH-CN\"/>\n" +
                "                                                    </w:rPr>\n" +
                "                                                    <w:instrText> PAGE \\* MERGEFORMAT</w:instrText>\n" +
                "                                                </w:r>\n" +
                "                                                <w:r>\n" +
                "                                                    <w:rPr>\n" +
                "                                                        <w:rFonts w:hint=\"fareast\"/>\n" +
                "                                                        <w:lang w:fareast=\"ZH-CN\"/>\n" +
                "                                                    </w:rPr>\n" +
                "                                                    <w:fldChar w:fldCharType=\"separate\"/>\n" +
                "                                                </w:r>\n" +
                "                                                <w:r>\n" +
                "                                                    <w:rPr>\n" +
                "                                                        <w:rFonts w:hint=\"fareast\"/>\n" +
                "                                                        <w:lang w:fareast=\"ZH-CN\"/>\n" +
                "                                                    </w:rPr>\n" +
                "                                                    <w:t>1</w:t>\n" +
                "                                                </w:r>\n" +
                "                                                <w:r>\n" +
                "                                                    <w:rPr>\n" +
                "                                                        <w:rFonts w:hint=\"fareast\"/>\n" +
                "                                                        <w:lang w:fareast=\"ZH-CN\"/>\n" +
                "                                                    </w:rPr>\n" +
                "                                                    <w:fldChar w:fldCharType=\"end\"/>\n" +
                "                                                </w:r>\n" +
                "                                            </w:p>\n" +
                "                                        </w:txbxContent>\n" +
                "                                    </v:textbox>\n" +
                "                                </v:shape>\n" +
                "                            </w:pict>\n" +
                "                        </w:r>\n" +
                "                    </w:p>\n" +
                "                </w:ftr>\n" +
                "                <w:pgSz w:w=\"11906\" w:h=\"16838\"/>\n" +
                "                <w:pgMar w:top=\"1440\" w:right=\"1800\" w:bottom=\"1440\" w:left=\"1800\" w:header=\"851\" w:footer=\"992\"\n" +
                "                         w:gutter=\"0\"/>\n" +
                "                <w:pgNumType/>\n" +
                "                <w:cols w:space=\"425\"/>\n" +
                "                <w:docGrid w:type=\"lines\" w:line-pitch=\"312\"/>\n" +
                "            </w:sectPr>";
    }
    public static String tableTile(String technologyName,String strategy){
        return "            <w:p>\n" +
                "                <w:pPr>\n" +
                "                    <w:tabs>\n" +
                "                        <w:tab w:val=\"left\" w:pos=\"5422\"/>\n" +
                "                    </w:tabs>\n" +
                "                </w:pPr>\n" +
                "                <w:r><w:rPr><w:rFonts w:hint=\"fareast\"/></w:rPr><w:t>关键技术:"+technologyName+"</w:t></w:r><w:r>\n" +
                "                    <w:rPr>\n" +
                "                        <w:rFonts w:hint=\"fareast\"/>\n" +
                "                    </w:rPr>\n" +
                "                    <w:tab/>\n" +
                "                </w:r>\n" +
                "                <w:r><w:rPr><w:rFonts w:hint=\"fareast\"/></w:rPr><w:t>替换策略:"+strategy+"</w:t></w:r></w:p>"+"<w:tbl>\n" +
                "                <w:tblPr>\n" +
                "                    <w:tblStyle w:val=\"a13\"/>\n" +
                "                    <w:tblW w:w=\"0\" w:type=\"auto\"/>\n" +
                "                    <w:tblInd w:w=\"0\" w:type=\"dxa\"/>\n" +
                "                    <w:tblBorders>\n" +
                "                        <w:top w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                        <w:left w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                        <w:bottom w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                        <w:right w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                        <w:insideH w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                        <w:insideV w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                    </w:tblBorders>\n" +
                "                    <w:tblCellMar>\n" +
                "                        <w:top w:w=\"0\" w:type=\"dxa\"/>\n" +
                "                        <w:left w:w=\"108\" w:type=\"dxa\"/>\n" +
                "                        <w:bottom w:w=\"0\" w:type=\"dxa\"/>\n" +
                "                        <w:right w:w=\"108\" w:type=\"dxa\"/>\n" +
                "                    </w:tblCellMar>\n" +
                "                </w:tblPr>\n" +
                "                <w:tblGrid>\n" +
                "                    <w:gridCol w:w=\"1161\"/>\n" +
                "                    <w:gridCol w:w=\"6515\"/>\n" +
                "                    <w:gridCol w:w=\"846\"/>\n" +
                "                </w:tblGrid>\n" +
                "                <w:tr>\n" +
                "                    <w:tblPrEx>\n" +
                "                        <w:tblBorders>\n" +
                "                            <w:top w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                            <w:left w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                            <w:bottom w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                            <w:right w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                            <w:insideH w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                            <w:insideV w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                        </w:tblBorders>\n" +
                "                        <w:tblCellMar>\n" +
                "                            <w:top w:w=\"0\" w:type=\"dxa\"/>\n" +
                "                            <w:left w:w=\"108\" w:type=\"dxa\"/>\n" +
                "                            <w:bottom w:w=\"0\" w:type=\"dxa\"/>\n" +
                "                            <w:right w:w=\"108\" w:type=\"dxa\"/>\n" +
                "                        </w:tblCellMar>\n" +
                "                    </w:tblPrEx>\n" +
                "                    <w:trPr/>\n" +
                "                    <w:tc>\n" +
                "                        <w:tcPr>\n" +
                "                            <w:tcW w:w=\"579\" w:type=\"dxa\"/>\n" +
                "                            <w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"auto\"/>\n" +
                "                        </w:tcPr>\n" +
                "                        <w:p>\n" +
                "                            <w:pPr>\n" +
                "                                <w:spacing w:line=\"240\" w:line-rule=\"auto\"/>\n" +
                "                                <w:jc w:val=\"center\"/>\n" +
                "                                <w:rPr>\n" +
                "                                    <w:sz w:val=\"21\"/>\n" +
                "                                    <w:sz-cs w:val=\"21\"/>\n" +
                "                                </w:rPr>\n" +
                "                            </w:pPr>\n" +
                "                            <w:r>\n" +
                "                                <w:rPr>\n" +
                "                                    <w:rFonts w:hint=\"fareast\"/>\n" +
                "                                    <w:sz w:val=\"21\"/>\n" +
                "                                    <w:sz-cs w:val=\"21\"/>\n" +
                "                                </w:rPr>\n" +
                "                                <w:t>关键字</w:t>\n" +
                "                            </w:r>\n" +
                "                        </w:p>\n" +
                "                    </w:tc>\n" +
                "                    <w:tc>\n" +
                "                        <w:tcPr>\n" +
                "                            <w:tcW w:w=\"7484\" w:type=\"dxa\"/>\n" +
                "                            <w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"auto\"/>\n" +
                "                        </w:tcPr>\n" +
                "                        <w:p>\n" +
                "                            <w:pPr>\n" +
                "                                <w:spacing w:line=\"240\" w:line-rule=\"auto\"/>\n" +
                "                                <w:jc w:val=\"center\"/>\n" +
                "                                <w:rPr>\n" +
                "                                    <w:sz w:val=\"21\"/>\n" +
                "                                    <w:sz-cs w:val=\"21\"/>\n" +
                "                                </w:rPr>\n" +
                "                            </w:pPr>\n" +
                "                            <w:r>\n" +
                "                                <w:rPr>\n" +
                "                                    <w:rFonts w:hint=\"fareast\"/>\n" +
                "                                    <w:sz w:val=\"21\"/>\n" +
                "                                    <w:sz-cs w:val=\"21\"/>\n" +
                "                                </w:rPr>\n" +
                "                                <w:t>所在文件</w:t>\n" +
                "                            </w:r>\n" +
                "                        </w:p>\n" +
                "                    </w:tc>\n" +
                "                    <w:tc>\n" +
                "                        <w:tcPr>\n" +
                "                            <w:tcW w:w=\"459\" w:type=\"dxa\"/>\n" +
                "                            <w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"auto\"/>\n" +
                "                        </w:tcPr>\n" +
                "                        <w:p>\n" +
                "                            <w:pPr>\n" +
                "                                <w:spacing w:line=\"240\" w:line-rule=\"auto\"/>\n" +
                "                                <w:jc w:val=\"center\"/>\n" +
                "                                <w:rPr>\n" +
                "                                    <w:sz w:val=\"21\"/>\n" +
                "                                    <w:sz-cs w:val=\"21\"/>\n" +
                "                                </w:rPr>\n" +
                "                            </w:pPr>\n" +
                "                            <w:r>\n" +
                "                                <w:rPr>\n" +
                "                                    <w:rFonts w:hint=\"fareast\"/>\n" +
                "                                    <w:sz w:val=\"21\"/>\n" +
                "                                    <w:sz-cs w:val=\"21\"/>\n" +
                "                                </w:rPr>\n" +
                "                                <w:t>位置</w:t>\n" +
                "                            </w:r>\n" +
                "                        </w:p>\n" +
                "                    </w:tc>\n" +
                "                </w:tr>\n";
    }
    public static String enddard(){
        return "<w:sectPr>\n" +
                "                <w:hdr w:type=\"odd\">\n" +
                "                    <w:p>\n" +
                "                        <w:pPr>\n" +
                "                            <w:pStyle w:val=\"a7\"/>\n" +
                "                        </w:pPr>\n" +
                "                        <w:r>\n" +
                "                            <w:rPr>\n" +
                "                                <w:sz w:val=\"18\"/>\n" +
                "                            </w:rPr>\n" +
                "                            <w:pict>\n" +
                "                                <v:group id=\"组合 5\" o:spid=\"_x0000_s1026\" o:spt=\"203\"\n" +
                "                                         style=\"position:absolute;left:0pt;margin-left:0pt;margin-top:0pt;height:23.85pt;width:596.1pt;mso-position-horizontal-relative:page;mso-position-vertical-relative:page;z-index:251658240;mso-width-relative:margin;mso-height-relative:page;\"\n" +
                "                                         coordorigin=\"2107,1246\" coordsize=\"8306,477\">\n" +
                "                                    <o:lock v:ext=\"edit\" aspectratio=\"f\"/>\n" +
                "                                    <v:shape id=\"文本框 2\" o:spid=\"_x0000_s1027\" o:spt=\"202\" type=\"#_x0000_t202\"\n" +
                "                                             style=\"position:absolute;left:2107;top:1246;height:477;width:1388;\"\n" +
                "                                             filled=\"f\" stroked=\"f\" coordsize=\"21600,21600\">\n" +
                "                                        <v:path/>\n" +
                "                                        <v:fill on=\"f\" focussize=\"0,0\"/>\n" +
                "                                        <v:stroke on=\"f\" weight=\"0.5pt\"/>\n" +
                "                                        <v:imagedata o:title=\"\"/>\n" +
                "                                        <o:lock v:ext=\"edit\" aspectratio=\"f\"/>\n" +
                "                                        <v:textbox>\n" +
                "                                            <w:txbxContent>\n" +
                "                                                <w:p>\n" +
                "                                                    <w:pPr>\n" +
                "                                                        <w:rPr>\n" +
                "                                                            <w:rFonts w:ascii=\"汉仪雅酷黑 75W\" w:h-ansi=\"汉仪雅酷黑 75W\"\n" +
                "                                                                      w:fareast=\"汉仪雅酷黑 75W\" w:cs=\"汉仪雅酷黑 75W\"\n" +
                "                                                                      w:hint=\"fareast\"/>\n" +
                "                                                            <w:lang w:val=\"EN-US\" w:fareast=\"ZH-CN\"/>\n" +
                "                                                        </w:rPr>\n" +
                "                                                    </w:pPr>\n" +
                "                                                    <w:r>\n" +
                "                                                        <w:rPr>\n" +
                "                                                            <w:rFonts w:ascii=\"汉仪雅酷黑 75W\" w:h-ansi=\"汉仪雅酷黑 75W\"\n" +
                "                                                                      w:fareast=\"汉仪雅酷黑 75W\" w:cs=\"汉仪雅酷黑 75W\"\n" +
                "                                                                      w:hint=\"fareast\"/>\n" +
                "                                                            <w:lang w:val=\"EN-US\" w:fareast=\"ZH-CN\"/>\n" +
                "                                                        </w:rPr>\n" +
                "                                                        <w:t>工作项目</w:t>\n" +
                "                                                    </w:r>\n" +
                "                                                </w:p>\n" +
                "                                            </w:txbxContent>\n" +
                "                                        </v:textbox>\n" +
                "                                    </v:shape>\n" +
                "                                    <v:shape id=\"文本框 3\" o:spid=\"_x0000_s1028\" o:spt=\"202\" type=\"#_x0000_t202\"\n" +
                "                                             style=\"position:absolute;left:5566;top:1246;height:477;width:1388;\"\n" +
                "                                             filled=\"f\" stroked=\"f\" coordsize=\"21600,21600\">\n" +
                "                                        <v:path/>\n" +
                "                                        <v:fill on=\"f\" focussize=\"0,0\"/>\n" +
                "                                        <v:stroke on=\"f\" weight=\"0.5pt\"/>\n" +
                "                                        <v:imagedata o:title=\"\"/>\n" +
                "                                        <o:lock v:ext=\"edit\" aspectratio=\"f\"/>\n" +
                "                                        <v:textbox>\n" +
                "                                            <w:txbxContent>\n" +
                "                                                <w:p>\n" +
                "                                                    <w:pPr>\n" +
                "                                                        <w:jc w:val=\"center\"/>\n" +
                "                                                        <w:rPr>\n" +
                "                                                            <w:rFonts w:ascii=\"汉仪雅酷黑 75W\" w:h-ansi=\"汉仪雅酷黑 75W\"\n" +
                "                                                                      w:fareast=\"汉仪雅酷黑 75W\" w:cs=\"汉仪雅酷黑 75W\"\n" +
                "                                                                      w:hint=\"fareast\"/>\n" +
                "                                                            <w:lang w:val=\"EN-US\" w:fareast=\"ZH-CN\"/>\n" +
                "                                                        </w:rPr>\n" +
                "                                                    </w:pPr>\n" +
                "                                                    <w:r>\n" +
                "                                                        <w:rPr>\n" +
                "                                                            <w:rFonts w:ascii=\"汉仪雅酷黑 75W\" w:h-ansi=\"汉仪雅酷黑 75W\"\n" +
                "                                                                      w:fareast=\"汉仪雅酷黑 75W\" w:cs=\"汉仪雅酷黑 75W\"\n" +
                "                                                                      w:hint=\"fareast\"/>\n" +
                "                                                            <w:lang w:val=\"EN-US\" w:fareast=\"ZH-CN\"/>\n" +
                "                                                        </w:rPr>\n" +
                "                                                        <w:t>工作内容</w:t>\n" +
                "                                                    </w:r>\n" +
                "                                                </w:p>\n" +
                "                                            </w:txbxContent>\n" +
                "                                        </v:textbox>\n" +
                "                                    </v:shape>\n" +
                "                                    <v:shape id=\"文本框 4\" o:spid=\"_x0000_s1029\" o:spt=\"202\" type=\"#_x0000_t202\"\n" +
                "                                             style=\"position:absolute;left:9025;top:1246;height:477;width:1388;\"\n" +
                "                                             filled=\"f\" stroked=\"f\" coordsize=\"21600,21600\">\n" +
                "                                        <v:path/>\n" +
                "                                        <v:fill on=\"f\" focussize=\"0,0\"/>\n" +
                "                                        <v:stroke on=\"f\" weight=\"0.5pt\"/>\n" +
                "                                        <v:imagedata o:title=\"\"/>\n" +
                "                                        <o:lock v:ext=\"edit\" aspectratio=\"f\"/>\n" +
                "                                        <v:textbox>\n" +
                "                                            <w:txbxContent>\n" +
                "                                                <w:p>\n" +
                "                                                    <w:pPr>\n" +
                "                                                        <w:jc w:val=\"right\"/>\n" +
                "                                                        <w:rPr>\n" +
                "                                                            <w:rFonts w:ascii=\"汉仪雅酷黑 75W\" w:h-ansi=\"汉仪雅酷黑 75W\"\n" +
                "                                                                      w:fareast=\"汉仪雅酷黑 75W\" w:cs=\"汉仪雅酷黑 75W\"\n" +
                "                                                                      w:hint=\"default\"/>\n" +
                "                                                            <w:lang w:val=\"EN-US\" w:fareast=\"ZH-CN\"/>\n" +
                "                                                        </w:rPr>\n" +
                "                                                    </w:pPr>\n" +
                "                                                    <w:r>\n" +
                "                                                        <w:rPr>\n" +
                "                                                            <w:rFonts w:ascii=\"汉仪雅酷黑 75W\" w:h-ansi=\"汉仪雅酷黑 75W\"\n" +
                "                                                                      w:fareast=\"汉仪雅酷黑 75W\" w:cs=\"汉仪雅酷黑 75W\"\n" +
                "                                                                      w:hint=\"fareast\"/>\n" +
                "                                                            <w:lang w:val=\"EN-US\" w:fareast=\"ZH-CN\"/>\n" +
                "                                                        </w:rPr>\n" +
                "                                                        <w:t>公司名称</w:t>\n" +
                "                                                    </w:r>\n" +
                "                                                </w:p>\n" +
                "                                            </w:txbxContent>\n" +
                "                                        </v:textbox>\n" +
                "                                    </v:shape>\n" +
                "                                    <v:line id=\"直接连接符 1\" o:spid=\"_x0000_s1030\" o:spt=\"20\"\n" +
                "                                            style=\"position:absolute;left:2107;top:1723;height:0;width:8305;\" filled=\"f\"\n" +
                "                                            stroked=\"t\" coordsize=\"21600,21600\">\n" +
                "                                        <v:path arrowok=\"t\"/>\n" +
                "                                        <v:fill on=\"f\" focussize=\"0,0\"/>\n" +
                "                                        <v:stroke color=\"#000000\" joinstyle=\"round\"/>\n" +
                "                                        <v:imagedata o:title=\"\"/>\n" +
                "                                        <o:lock v:ext=\"edit\" aspectratio=\"f\"/>\n" +
                "                                    </v:line>\n" +
                "                                </v:group>\n" +
                "                            </w:pict>\n" +
                "                        </w:r>\n" +
                "                    </w:p>\n" +
                "                </w:hdr>\n" +
                "                <w:ftr w:type=\"odd\">\n" +
                "                    <w:p>\n" +
                "                        <w:pPr>\n" +
                "                            <w:pStyle w:val=\"a6\"/>\n" +
                "                        </w:pPr>\n" +
                "                        <w:r>\n" +
                "                            <w:rPr>\n" +
                "                                <w:sz w:val=\"18\"/>\n" +
                "                            </w:rPr>\n" +
                "                            <w:pict>\n" +
                "                                <v:shape id=\"_x0000_s1031\" o:spt=\"202\" type=\"#_x0000_t202\"\n" +
                "                                         style=\"position:absolute;left:0pt;margin-top:0pt;height:144pt;width:144pt;mso-position-horizontal:center;mso-position-horizontal-relative:margin;mso-wrap-style:none;z-index:251659264;mso-width-relative:page;mso-height-relative:page;\"\n" +
                "                                         filled=\"f\" stroked=\"f\" coordsize=\"21600,21600\">\n" +
                "                                    <v:path/>\n" +
                "                                    <v:fill on=\"f\" focussize=\"0,0\"/>\n" +
                "                                    <v:stroke on=\"f\"/>\n" +
                "                                    <v:imagedata o:title=\"\"/>\n" +
                "                                    <o:lock v:ext=\"edit\" aspectratio=\"f\"/>\n" +
                "                                    <v:textbox inset=\"0.00pt,0.00pt,0.00pt,0.00pt\" style=\"mso-fit-shape-to-text:t;\">\n" +
                "                                        <w:txbxContent>\n" +
                "                                            <w:p>\n" +
                "                                                <w:pPr>\n" +
                "                                                    <w:pStyle w:val=\"a6\"/>\n" +
                "                                                    <w:rPr>\n" +
                "                                                        <w:rFonts w:fareast=\"宋体\" w:hint=\"fareast\"/>\n" +
                "                                                        <w:lang w:fareast=\"ZH-CN\"/>\n" +
                "                                                    </w:rPr>\n" +
                "                                                </w:pPr>\n" +
                "                                                <w:r>\n" +
                "                                                    <w:rPr>\n" +
                "                                                        <w:rFonts w:hint=\"fareast\"/>\n" +
                "                                                        <w:lang w:fareast=\"ZH-CN\"/>\n" +
                "                                                    </w:rPr>\n" +
                "                                                    <w:fldChar w:fldCharType=\"begin\"/>\n" +
                "                                                </w:r>\n" +
                "                                                <w:r>\n" +
                "                                                    <w:rPr>\n" +
                "                                                        <w:rFonts w:hint=\"fareast\"/>\n" +
                "                                                        <w:lang w:fareast=\"ZH-CN\"/>\n" +
                "                                                    </w:rPr>\n" +
                "                                                    <w:instrText> PAGE \\* MERGEFORMAT</w:instrText>\n" +
                "                                                </w:r>\n" +
                "                                                <w:r>\n" +
                "                                                    <w:rPr>\n" +
                "                                                        <w:rFonts w:hint=\"fareast\"/>\n" +
                "                                                        <w:lang w:fareast=\"ZH-CN\"/>\n" +
                "                                                    </w:rPr>\n" +
                "                                                    <w:fldChar w:fldCharType=\"separate\"/>\n" +
                "                                                </w:r>\n" +
                "                                                <w:r>\n" +
                "                                                    <w:rPr>\n" +
                "                                                        <w:rFonts w:hint=\"fareast\"/>\n" +
                "                                                        <w:lang w:fareast=\"ZH-CN\"/>\n" +
                "                                                    </w:rPr>\n" +
                "                                                    <w:t>1</w:t>\n" +
                "                                                </w:r>\n" +
                "                                                <w:r>\n" +
                "                                                    <w:rPr>\n" +
                "                                                        <w:rFonts w:hint=\"fareast\"/>\n" +
                "                                                        <w:lang w:fareast=\"ZH-CN\"/>\n" +
                "                                                    </w:rPr>\n" +
                "                                                    <w:fldChar w:fldCharType=\"end\"/>\n" +
                "                                                </w:r>\n" +
                "                                            </w:p>\n" +
                "                                        </w:txbxContent>\n" +
                "                                    </v:textbox>\n" +
                "                                </v:shape>\n" +
                "                            </w:pict>\n" +
                "                        </w:r>\n" +
                "                    </w:p>\n" +
                "                </w:ftr>\n" +
                "                <w:pgSz w:w=\"11906\" w:h=\"16838\"/>\n" +
                "                <w:pgMar w:top=\"1440\" w:right=\"1800\" w:bottom=\"1440\" w:left=\"1800\" w:header=\"851\" w:footer=\"992\"\n" +
                "                         w:gutter=\"0\"/>\n" +
                "                <w:pgNumType/>\n" +
                "                <w:cols w:space=\"425\"/>\n" +
                "                <w:docGrid w:type=\"lines\" w:line-pitch=\"312\"/>\n" +
                "            </w:sectPr>\n" +
                "        </wx:sect>\n" +
                "    </w:body>\n" +
                "</w:wordDocument>";
    }
    public static String standard(){
        String str="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n" +
                "<?mso-application progid=\"Word.Document\"?>\n" +
                "<w:wordDocument xmlns:w=\"http://schemas.microsoft.com/office/word/2003/wordml\" xmlns:v=\"urn:schemas-microsoft-com:vml\"\n" +
                "                xmlns:w10=\"urn:schemas-microsoft-com:office:word\"\n" +
                "                xmlns:sl=\"http://schemas.microsoft.com/schemaLibrary/2003/core\"\n" +
                "                xmlns:aml=\"http://schemas.microsoft.com/aml/2001/core\"\n" +
                "                xmlns:wx=\"http://schemas.microsoft.com/office/word/2003/auxHint\"\n" +
                "                xmlns:o=\"urn:schemas-microsoft-com:office:office\" xmlns:dt=\"uuid:C2F41010-65B3-11d1-A29F-00AA00C14882\"\n" +
                "                w:macrosPresent=\"no\" w:embeddedObjPresent=\"no\" w:ocxPresent=\"no\" xml:space=\"preserve\"><o:DocumentProperties>\n" +
                "        <o:Author>Jey</o:Author>\n" +
                "        <o:LastAuthor>jey</o:LastAuthor>\n" +
                "        <o:Created>2014-10-29T12:08:00Z</o:Created>\n" +
                "        <o:LastSaved>2020-04-16T01:31:51Z</o:LastSaved>\n" +
                "        <o:TotalTime>18720</o:TotalTime>\n" +
                "        <o:Pages>1</o:Pages>\n" +
                "        <o:Words>0</o:Words>\n" +
                "        <o:Characters>0</o:Characters>\n" +
                "        <o:Lines>0</o:Lines>\n" +
                "        <o:Paragraphs>0</o:Paragraphs>\n" +
                "        <o:CharactersWithSpaces>0</o:CharactersWithSpaces>\n" +
                "        <o:Version>14</o:Version>\n" +
                "    </o:DocumentProperties>\n" +
                "    <o:CustomDocumentProperties>\n" +
                "        <o:KSOProductBuildVer dt:dt=\"string\">2052-11.1.0.9584</o:KSOProductBuildVer>\n" +
                "    </o:CustomDocumentProperties>\n" +
                "    <w:fonts>\n" +
                "        <w:defaultFonts w:ascii=\"Calibri\" w:fareast=\"宋体\" w:h-ansi=\"Calibri\" w:cs=\"Times New Roman\"/>\n" +
                "        <w:font w:name=\"Times New Roman\">\n" +
                "            <w:panose-1 w:val=\"02020603050405020304\"/>\n" +
                "            <w:charset w:val=\"00\"/>\n" +
                "            <w:family w:val=\"Auto\"/>\n" +
                "            <w:pitch w:val=\"Default\"/>\n" +
                "            <w:sig w:usb-0=\"E0002EFF\" w:usb-1=\"C000785B\" w:usb-2=\"00000009\" w:usb-3=\"00000000\" w:csb-0=\"400001FF\"\n" +
                "                   w:csb-1=\"FFFF0000\"/>\n" +
                "        </w:font>\n" +
                "        <w:font w:name=\"宋体\">\n" +
                "            <w:panose-1 w:val=\"02010600030101010101\"/>\n" +
                "            <w:charset w:val=\"86\"/>\n" +
                "            <w:family w:val=\"Auto\"/>\n" +
                "            <w:pitch w:val=\"Default\"/>\n" +
                "            <w:sig w:usb-0=\"00000003\" w:usb-1=\"288F0000\" w:usb-2=\"00000006\" w:usb-3=\"00000000\" w:csb-0=\"00040001\"\n" +
                "                   w:csb-1=\"00000000\"/>\n" +
                "        </w:font>\n" +
                "        <w:font w:name=\"Wingdings\">\n" +
                "            <w:panose-1 w:val=\"05000000000000000000\"/>\n" +
                "            <w:charset w:val=\"02\"/>\n" +
                "            <w:family w:val=\"Auto\"/>\n" +
                "            <w:pitch w:val=\"Default\"/>\n" +
                "            <w:sig w:usb-0=\"00000000\" w:usb-1=\"00000000\" w:usb-2=\"00000000\" w:usb-3=\"00000000\" w:csb-0=\"80000000\"\n" +
                "                   w:csb-1=\"00000000\"/>\n" +
                "        </w:font>\n" +
                "        <w:font w:name=\"Arial\">\n" +
                "            <w:panose-1 w:val=\"020B0604020202020204\"/>\n" +
                "            <w:charset w:val=\"01\"/>\n" +
                "            <w:family w:val=\"SWiss\"/>\n" +
                "            <w:pitch w:val=\"Default\"/>\n" +
                "            <w:sig w:usb-0=\"E0002EFF\" w:usb-1=\"C000785B\" w:usb-2=\"00000009\" w:usb-3=\"00000000\" w:csb-0=\"400001FF\"\n" +
                "                   w:csb-1=\"FFFF0000\"/>\n" +
                "        </w:font>\n" +
                "        <w:font w:name=\"黑体\">\n" +
                "            <w:panose-1 w:val=\"02010609060101010101\"/>\n" +
                "            <w:charset w:val=\"86\"/>\n" +
                "            <w:family w:val=\"Auto\"/>\n" +
                "            <w:pitch w:val=\"Default\"/>\n" +
                "            <w:sig w:usb-0=\"800002BF\" w:usb-1=\"38CF7CFA\" w:usb-2=\"00000016\" w:usb-3=\"00000000\" w:csb-0=\"00040001\"\n" +
                "                   w:csb-1=\"00000000\"/>\n" +
                "        </w:font>\n" +
                "        <w:font w:name=\"Courier New\">\n" +
                "            <w:panose-1 w:val=\"02070309020205020404\"/>\n" +
                "            <w:charset w:val=\"01\"/>\n" +
                "            <w:family w:val=\"Modern\"/>\n" +
                "            <w:pitch w:val=\"Default\"/>\n" +
                "            <w:sig w:usb-0=\"E0002EFF\" w:usb-1=\"C0007843\" w:usb-2=\"00000009\" w:usb-3=\"00000000\" w:csb-0=\"400001FF\"\n" +
                "                   w:csb-1=\"FFFF0000\"/>\n" +
                "        </w:font>\n" +
                "        <w:font w:name=\"Symbol\">\n" +
                "            <w:panose-1 w:val=\"05050102010706020507\"/>\n" +
                "            <w:charset w:val=\"02\"/>\n" +
                "            <w:family w:val=\"Roman\"/>\n" +
                "            <w:pitch w:val=\"Default\"/>\n" +
                "            <w:sig w:usb-0=\"00000000\" w:usb-1=\"00000000\" w:usb-2=\"00000000\" w:usb-3=\"00000000\" w:csb-0=\"80000000\"\n" +
                "                   w:csb-1=\"00000000\"/>\n" +
                "        </w:font>\n" +
                "        <w:font w:name=\"Calibri\">\n" +
                "            <w:panose-1 w:val=\"020F0502020204030204\"/>\n" +
                "            <w:charset w:val=\"00\"/>\n" +
                "            <w:family w:val=\"SWiss\"/>\n" +
                "            <w:pitch w:val=\"Default\"/>\n" +
                "            <w:sig w:usb-0=\"E0002EFF\" w:usb-1=\"C000247B\" w:usb-2=\"00000009\" w:usb-3=\"00000000\" w:csb-0=\"200001FF\"\n" +
                "                   w:csb-1=\"00000000\"/>\n" +
                "        </w:font>\n" +
                "        <w:font w:name=\"Wingdings\">\n" +
                "            <w:panose-1 w:val=\"05000000000000000000\"/>\n" +
                "            <w:charset w:val=\"00\"/>\n" +
                "            <w:family w:val=\"Auto\"/>\n" +
                "            <w:pitch w:val=\"Default\"/>\n" +
                "            <w:sig w:usb-0=\"00000000\" w:usb-1=\"00000000\" w:usb-2=\"00000000\" w:usb-3=\"00000000\" w:csb-0=\"80000000\"\n" +
                "                   w:csb-1=\"00000000\"/>\n" +
                "        </w:font>\n" +
                "        <w:font w:name=\"Arial\">\n" +
                "            <w:panose-1 w:val=\"020B0604020202020204\"/>\n" +
                "            <w:charset w:val=\"00\"/>\n" +
                "            <w:family w:val=\"Auto\"/>\n" +
                "            <w:pitch w:val=\"Default\"/>\n" +
                "            <w:sig w:usb-0=\"E0002EFF\" w:usb-1=\"C000785B\" w:usb-2=\"00000009\" w:usb-3=\"00000000\" w:csb-0=\"400001FF\"\n" +
                "                   w:csb-1=\"FFFF0000\"/>\n" +
                "        </w:font>\n" +
                "        <w:font w:name=\"Courier New\">\n" +
                "            <w:panose-1 w:val=\"02070309020205020404\"/>\n" +
                "            <w:charset w:val=\"00\"/>\n" +
                "            <w:family w:val=\"Auto\"/>\n" +
                "            <w:pitch w:val=\"Default\"/>\n" +
                "            <w:sig w:usb-0=\"E0002EFF\" w:usb-1=\"C0007843\" w:usb-2=\"00000009\" w:usb-3=\"00000000\" w:csb-0=\"400001FF\"\n" +
                "                   w:csb-1=\"FFFF0000\"/>\n" +
                "        </w:font>\n" +
                "        <w:font w:name=\"Symbol\">\n" +
                "            <w:panose-1 w:val=\"05050102010706020507\"/>\n" +
                "            <w:charset w:val=\"00\"/>\n" +
                "            <w:family w:val=\"Auto\"/>\n" +
                "            <w:pitch w:val=\"Default\"/>\n" +
                "            <w:sig w:usb-0=\"00000000\" w:usb-1=\"00000000\" w:usb-2=\"00000000\" w:usb-3=\"00000000\" w:csb-0=\"80000000\"\n" +
                "                   w:csb-1=\"00000000\"/>\n" +
                "        </w:font>\n" +
                "        <w:font w:name=\"汉仪雅酷黑 75W\">\n" +
                "            <w:altName w:val=\"黑体\"/>\n" +
                "            <w:panose-1 w:val=\"020B0804020202020204\"/>\n" +
                "            <w:charset w:val=\"86\"/>\n" +
                "            <w:family w:val=\"Auto\"/>\n" +
                "            <w:pitch w:val=\"Default\"/>\n" +
                "            <w:sig w:usb-0=\"00000000\" w:usb-1=\"00000000\" w:usb-2=\"00000016\" w:usb-3=\"00000000\" w:csb-0=\"2004000F\"\n" +
                "                   w:csb-1=\"00000000\"/>\n" +
                "        </w:font>\n" +
                "    </w:fonts>\n" +
                "    <w:styles>\n" +
                "        <w:latentStyles w:defLockedState=\"off\" w:latentStyleCount=\"260\">\n" +
                "            <w:lsdException w:name=\"Normal\"/>\n" +
                "            <w:lsdException w:name=\"heading 1\"/>\n" +
                "            <w:lsdException w:name=\"heading 2\"/>\n" +
                "            <w:lsdException w:name=\"heading 3\"/>\n" +
                "            <w:lsdException w:name=\"heading 4\"/>\n" +
                "            <w:lsdException w:name=\"heading 5\"/>\n" +
                "            <w:lsdException w:name=\"heading 6\"/>\n" +
                "            <w:lsdException w:name=\"heading 7\"/>\n" +
                "            <w:lsdException w:name=\"heading 8\"/>\n" +
                "            <w:lsdException w:name=\"heading 9\"/>\n" +
                "            <w:lsdException w:name=\"index 1\"/>\n" +
                "            <w:lsdException w:name=\"index 2\"/>\n" +
                "            <w:lsdException w:name=\"index 3\"/>\n" +
                "            <w:lsdException w:name=\"index 4\"/>\n" +
                "            <w:lsdException w:name=\"index 5\"/>\n" +
                "            <w:lsdException w:name=\"index 6\"/>\n" +
                "            <w:lsdException w:name=\"index 7\"/>\n" +
                "            <w:lsdException w:name=\"index 8\"/>\n" +
                "            <w:lsdException w:name=\"index 9\"/>\n" +
                "            <w:lsdException w:name=\"toc 1\"/>\n" +
                "            <w:lsdException w:name=\"toc 2\"/>\n" +
                "            <w:lsdException w:name=\"toc 3\"/>\n" +
                "            <w:lsdException w:name=\"toc 4\"/>\n" +
                "            <w:lsdException w:name=\"toc 5\"/>\n" +
                "            <w:lsdException w:name=\"toc 6\"/>\n" +
                "            <w:lsdException w:name=\"toc 7\"/>\n" +
                "            <w:lsdException w:name=\"toc 8\"/>\n" +
                "            <w:lsdException w:name=\"toc 9\"/>\n" +
                "            <w:lsdException w:name=\"Normal Indent\"/>\n" +
                "            <w:lsdException w:name=\"footnote text\"/>\n" +
                "            <w:lsdException w:name=\"annotation text\"/>\n" +
                "            <w:lsdException w:name=\"header\"/>\n" +
                "            <w:lsdException w:name=\"footer\"/>\n" +
                "            <w:lsdException w:name=\"index heading\"/>\n" +
                "            <w:lsdException w:name=\"caption\"/>\n" +
                "            <w:lsdException w:name=\"table of figures\"/>\n" +
                "            <w:lsdException w:name=\"envelope address\"/>\n" +
                "            <w:lsdException w:name=\"envelope return\"/>\n" +
                "            <w:lsdException w:name=\"footnote reference\"/>\n" +
                "            <w:lsdException w:name=\"annotation reference\"/>\n" +
                "            <w:lsdException w:name=\"line number\"/>\n" +
                "            <w:lsdException w:name=\"page number\"/>\n" +
                "            <w:lsdException w:name=\"endnote reference\"/>\n" +
                "            <w:lsdException w:name=\"endnote text\"/>\n" +
                "            <w:lsdException w:name=\"table of authorities\"/>\n" +
                "            <w:lsdException w:name=\"macro\"/>\n" +
                "            <w:lsdException w:name=\"toa heading\"/>\n" +
                "            <w:lsdException w:name=\"List\"/>\n" +
                "            <w:lsdException w:name=\"List Bullet\"/>\n" +
                "            <w:lsdException w:name=\"List Number\"/>\n" +
                "            <w:lsdException w:name=\"List 2\"/>\n" +
                "            <w:lsdException w:name=\"List 3\"/>\n" +
                "            <w:lsdException w:name=\"List 4\"/>\n" +
                "            <w:lsdException w:name=\"List 5\"/>\n" +
                "            <w:lsdException w:name=\"List Bullet 2\"/>\n" +
                "            <w:lsdException w:name=\"List Bullet 3\"/>\n" +
                "            <w:lsdException w:name=\"List Bullet 4\"/>\n" +
                "            <w:lsdException w:name=\"List Bullet 5\"/>\n" +
                "            <w:lsdException w:name=\"List Number 2\"/>\n" +
                "            <w:lsdException w:name=\"List Number 3\"/>\n" +
                "            <w:lsdException w:name=\"List Number 4\"/>\n" +
                "            <w:lsdException w:name=\"List Number 5\"/>\n" +
                "            <w:lsdException w:name=\"Title\"/>\n" +
                "            <w:lsdException w:name=\"Closing\"/>\n" +
                "            <w:lsdException w:name=\"Signature\"/>\n" +
                "            <w:lsdException w:name=\"Default Paragraph Font\"/>\n" +
                "            <w:lsdException w:name=\"Body Text\"/>\n" +
                "            <w:lsdException w:name=\"Body Text Indent\"/>\n" +
                "            <w:lsdException w:name=\"List Continue\"/>\n" +
                "            <w:lsdException w:name=\"List Continue 2\"/>\n" +
                "            <w:lsdException w:name=\"List Continue 3\"/>\n" +
                "            <w:lsdException w:name=\"List Continue 4\"/>\n" +
                "            <w:lsdException w:name=\"List Continue 5\"/>\n" +
                "            <w:lsdException w:name=\"Message Header\"/>\n" +
                "            <w:lsdException w:name=\"Subtitle\"/>\n" +
                "            <w:lsdException w:name=\"Salutation\"/>\n" +
                "            <w:lsdException w:name=\"Date\"/>\n" +
                "            <w:lsdException w:name=\"Body Text First Indent\"/>\n" +
                "            <w:lsdException w:name=\"Body Text First Indent 2\"/>\n" +
                "            <w:lsdException w:name=\"Note Heading\"/>\n" +
                "            <w:lsdException w:name=\"Body Text 2\"/>\n" +
                "            <w:lsdException w:name=\"Body Text 3\"/>\n" +
                "            <w:lsdException w:name=\"Body Text Indent 2\"/>\n" +
                "            <w:lsdException w:name=\"Body Text Indent 3\"/>\n" +
                "            <w:lsdException w:name=\"Block Text\"/>\n" +
                "            <w:lsdException w:name=\"Hyperlink\"/>\n" +
                "            <w:lsdException w:name=\"FollowedHyperlink\"/>\n" +
                "            <w:lsdException w:name=\"Strong\"/>\n" +
                "            <w:lsdException w:name=\"Emphasis\"/>\n" +
                "            <w:lsdException w:name=\"Document Map\"/>\n" +
                "            <w:lsdException w:name=\"Plain Text\"/>\n" +
                "            <w:lsdException w:name=\"E-mail Signature\"/>\n" +
                "            <w:lsdException w:name=\"Normal (Web)\"/>\n" +
                "            <w:lsdException w:name=\"HTML Acronym\"/>\n" +
                "            <w:lsdException w:name=\"HTML Address\"/>\n" +
                "            <w:lsdException w:name=\"HTML Cite\"/>\n" +
                "            <w:lsdException w:name=\"HTML Code\"/>\n" +
                "            <w:lsdException w:name=\"HTML Definition\"/>\n" +
                "            <w:lsdException w:name=\"HTML Keyboard\"/>\n" +
                "            <w:lsdException w:name=\"HTML Preformatted\"/>\n" +
                "            <w:lsdException w:name=\"HTML Sample\"/>\n" +
                "            <w:lsdException w:name=\"HTML Typewriter\"/>\n" +
                "            <w:lsdException w:name=\"HTML Variable\"/>\n" +
                "            <w:lsdException w:name=\"Normal Table\"/>\n" +
                "            <w:lsdException w:name=\"annotation subject\"/>\n" +
                "            <w:lsdException w:name=\"Table Simple 1\"/>\n" +
                "            <w:lsdException w:name=\"Table Simple 2\"/>\n" +
                "            <w:lsdException w:name=\"Table Simple 3\"/>\n" +
                "            <w:lsdException w:name=\"Table Classic 1\"/>\n" +
                "            <w:lsdException w:name=\"Table Classic 2\"/>\n" +
                "            <w:lsdException w:name=\"Table Classic 3\"/>\n" +
                "            <w:lsdException w:name=\"Table Classic 4\"/>\n" +
                "            <w:lsdException w:name=\"Table Colorful 1\"/>\n" +
                "            <w:lsdException w:name=\"Table Colorful 2\"/>\n" +
                "            <w:lsdException w:name=\"Table Colorful 3\"/>\n" +
                "            <w:lsdException w:name=\"Table Columns 1\"/>\n" +
                "            <w:lsdException w:name=\"Table Columns 2\"/>\n" +
                "            <w:lsdException w:name=\"Table Columns 3\"/>\n" +
                "            <w:lsdException w:name=\"Table Columns 4\"/>\n" +
                "            <w:lsdException w:name=\"Table Columns 5\"/>\n" +
                "            <w:lsdException w:name=\"Table Grid 1\"/>\n" +
                "            <w:lsdException w:name=\"Table Grid 2\"/>\n" +
                "            <w:lsdException w:name=\"Table Grid 3\"/>\n" +
                "            <w:lsdException w:name=\"Table Grid 4\"/>\n" +
                "            <w:lsdException w:name=\"Table Grid 5\"/>\n" +
                "            <w:lsdException w:name=\"Table Grid 6\"/>\n" +
                "            <w:lsdException w:name=\"Table Grid 7\"/>\n" +
                "            <w:lsdException w:name=\"Table Grid 8\"/>\n" +
                "            <w:lsdException w:name=\"Table List 1\"/>\n" +
                "            <w:lsdException w:name=\"Table List 2\"/>\n" +
                "            <w:lsdException w:name=\"Table List 3\"/>\n" +
                "            <w:lsdException w:name=\"Table List 4\"/>\n" +
                "            <w:lsdException w:name=\"Table List 5\"/>\n" +
                "            <w:lsdException w:name=\"Table List 6\"/>\n" +
                "            <w:lsdException w:name=\"Table List 7\"/>\n" +
                "            <w:lsdException w:name=\"Table List 8\"/>\n" +
                "            <w:lsdException w:name=\"Table 3D effects 1\"/>\n" +
                "            <w:lsdException w:name=\"Table 3D effects 2\"/>\n" +
                "            <w:lsdException w:name=\"Table 3D effects 3\"/>\n" +
                "            <w:lsdException w:name=\"Table Contemporary\"/>\n" +
                "            <w:lsdException w:name=\"Table Elegant\"/>\n" +
                "            <w:lsdException w:name=\"Table Professional\"/>\n" +
                "            <w:lsdException w:name=\"Table Subtle 1\"/>\n" +
                "            <w:lsdException w:name=\"Table Subtle 2\"/>\n" +
                "            <w:lsdException w:name=\"Table Web 1\"/>\n" +
                "            <w:lsdException w:name=\"Table Web 2\"/>\n" +
                "            <w:lsdException w:name=\"Table Web 3\"/>\n" +
                "            <w:lsdException w:name=\"Balloon Text\"/>\n" +
                "            <w:lsdException w:name=\"Table Grid\"/>\n" +
                "            <w:lsdException w:name=\"Table Theme\"/>\n" +
                "            <w:lsdException w:name=\"Light Shading\"/>\n" +
                "            <w:lsdException w:name=\"Light List\"/>\n" +
                "            <w:lsdException w:name=\"Light Grid\"/>\n" +
                "            <w:lsdException w:name=\"Medium Shading 1\"/>\n" +
                "            <w:lsdException w:name=\"Medium Shading 2\"/>\n" +
                "            <w:lsdException w:name=\"Medium List 1\"/>\n" +
                "            <w:lsdException w:name=\"Medium List 2\"/>\n" +
                "            <w:lsdException w:name=\"Medium Grid 1\"/>\n" +
                "            <w:lsdException w:name=\"Medium Grid 2\"/>\n" +
                "            <w:lsdException w:name=\"Medium Grid 3\"/>\n" +
                "            <w:lsdException w:name=\"Dark List\"/>\n" +
                "            <w:lsdException w:name=\"Colorful Shading\"/>\n" +
                "            <w:lsdException w:name=\"Colorful List\"/>\n" +
                "            <w:lsdException w:name=\"Colorful Grid\"/>\n" +
                "            <w:lsdException w:name=\"Light Shading Accent 1\"/>\n" +
                "            <w:lsdException w:name=\"Light List Accent 1\"/>\n" +
                "            <w:lsdException w:name=\"Light Grid Accent 1\"/>\n" +
                "            <w:lsdException w:name=\"Medium Shading 1 Accent 1\"/>\n" +
                "            <w:lsdException w:name=\"Medium Shading 2 Accent 1\"/>\n" +
                "            <w:lsdException w:name=\"Medium List 1 Accent 1\"/>\n" +
                "            <w:lsdException w:name=\"Medium List 2 Accent 1\"/>\n" +
                "            <w:lsdException w:name=\"Medium Grid 1 Accent 1\"/>\n" +
                "            <w:lsdException w:name=\"Medium Grid 2 Accent 1\"/>\n" +
                "            <w:lsdException w:name=\"Medium Grid 3 Accent 1\"/>\n" +
                "            <w:lsdException w:name=\"Dark List Accent 1\"/>\n" +
                "            <w:lsdException w:name=\"Colorful Shading Accent 1\"/>\n" +
                "            <w:lsdException w:name=\"Colorful List Accent 1\"/>\n" +
                "            <w:lsdException w:name=\"Colorful Grid Accent 1\"/>\n" +
                "            <w:lsdException w:name=\"Light Shading Accent 2\"/>\n" +
                "            <w:lsdException w:name=\"Light List Accent 2\"/>\n" +
                "            <w:lsdException w:name=\"Light Grid Accent 2\"/>\n" +
                "            <w:lsdException w:name=\"Medium Shading 1 Accent 2\"/>\n" +
                "            <w:lsdException w:name=\"Medium Shading 2 Accent 2\"/>\n" +
                "            <w:lsdException w:name=\"Medium List 1 Accent 2\"/>\n" +
                "            <w:lsdException w:name=\"Medium List 2 Accent 2\"/>\n" +
                "            <w:lsdException w:name=\"Medium Grid 1 Accent 2\"/>\n" +
                "            <w:lsdException w:name=\"Medium Grid 2 Accent 2\"/>\n" +
                "            <w:lsdException w:name=\"Medium Grid 3 Accent 2\"/>\n" +
                "            <w:lsdException w:name=\"Dark List Accent 2\"/>\n" +
                "            <w:lsdException w:name=\"Colorful Shading Accent 2\"/>\n" +
                "            <w:lsdException w:name=\"Colorful List Accent 2\"/>\n" +
                "            <w:lsdException w:name=\"Colorful Grid Accent 2\"/>\n" +
                "            <w:lsdException w:name=\"Light Shading Accent 3\"/>\n" +
                "            <w:lsdException w:name=\"Light List Accent 3\"/>\n" +
                "            <w:lsdException w:name=\"Light Grid Accent 3\"/>\n" +
                "            <w:lsdException w:name=\"Medium Shading 1 Accent 3\"/>\n" +
                "            <w:lsdException w:name=\"Medium Shading 2 Accent 3\"/>\n" +
                "            <w:lsdException w:name=\"Medium List 1 Accent 3\"/>\n" +
                "            <w:lsdException w:name=\"Medium List 2 Accent 3\"/>\n" +
                "            <w:lsdException w:name=\"Medium Grid 1 Accent 3\"/>\n" +
                "            <w:lsdException w:name=\"Medium Grid 2 Accent 3\"/>\n" +
                "            <w:lsdException w:name=\"Medium Grid 3 Accent 3\"/>\n" +
                "            <w:lsdException w:name=\"Dark List Accent 3\"/>\n" +
                "            <w:lsdException w:name=\"Colorful Shading Accent 3\"/>\n" +
                "            <w:lsdException w:name=\"Colorful List Accent 3\"/>\n" +
                "            <w:lsdException w:name=\"Colorful Grid Accent 3\"/>\n" +
                "            <w:lsdException w:name=\"Light Shading Accent 4\"/>\n" +
                "            <w:lsdException w:name=\"Light List Accent 4\"/>\n" +
                "            <w:lsdException w:name=\"Light Grid Accent 4\"/>\n" +
                "            <w:lsdException w:name=\"Medium Shading 1 Accent 4\"/>\n" +
                "            <w:lsdException w:name=\"Medium Shading 2 Accent 4\"/>\n" +
                "            <w:lsdException w:name=\"Medium List 1 Accent 4\"/>\n" +
                "            <w:lsdException w:name=\"Medium List 2 Accent 4\"/>\n" +
                "            <w:lsdException w:name=\"Medium Grid 1 Accent 4\"/>\n" +
                "            <w:lsdException w:name=\"Medium Grid 2 Accent 4\"/>\n" +
                "            <w:lsdException w:name=\"Medium Grid 3 Accent 4\"/>\n" +
                "            <w:lsdException w:name=\"Dark List Accent 4\"/>\n" +
                "            <w:lsdException w:name=\"Colorful Shading Accent 4\"/>\n" +
                "            <w:lsdException w:name=\"Colorful List Accent 4\"/>\n" +
                "            <w:lsdException w:name=\"Colorful Grid Accent 4\"/>\n" +
                "            <w:lsdException w:name=\"Light Shading Accent 5\"/>\n" +
                "            <w:lsdException w:name=\"Light List Accent 5\"/>\n" +
                "            <w:lsdException w:name=\"Light Grid Accent 5\"/>\n" +
                "            <w:lsdException w:name=\"Medium Shading 1 Accent 5\"/>\n" +
                "            <w:lsdException w:name=\"Medium Shading 2 Accent 5\"/>\n" +
                "            <w:lsdException w:name=\"Medium List 1 Accent 5\"/>\n" +
                "            <w:lsdException w:name=\"Medium List 2 Accent 5\"/>\n" +
                "            <w:lsdException w:name=\"Medium Grid 1 Accent 5\"/>\n" +
                "            <w:lsdException w:name=\"Medium Grid 2 Accent 5\"/>\n" +
                "            <w:lsdException w:name=\"Medium Grid 3 Accent 5\"/>\n" +
                "            <w:lsdException w:name=\"Dark List Accent 5\"/>\n" +
                "            <w:lsdException w:name=\"Colorful Shading Accent 5\"/>\n" +
                "            <w:lsdException w:name=\"Colorful List Accent 5\"/>\n" +
                "            <w:lsdException w:name=\"Colorful Grid Accent 5\"/>\n" +
                "            <w:lsdException w:name=\"Light Shading Accent 6\"/>\n" +
                "            <w:lsdException w:name=\"Light List Accent 6\"/>\n" +
                "            <w:lsdException w:name=\"Light Grid Accent 6\"/>\n" +
                "            <w:lsdException w:name=\"Medium Shading 1 Accent 6\"/>\n" +
                "            <w:lsdException w:name=\"Medium Shading 2 Accent 6\"/>\n" +
                "            <w:lsdException w:name=\"Medium List 1 Accent 6\"/>\n" +
                "            <w:lsdException w:name=\"Medium List 2 Accent 6\"/>\n" +
                "            <w:lsdException w:name=\"Medium Grid 1 Accent 6\"/>\n" +
                "            <w:lsdException w:name=\"Medium Grid 2 Accent 6\"/>\n" +
                "            <w:lsdException w:name=\"Medium Grid 3 Accent 6\"/>\n" +
                "            <w:lsdException w:name=\"Dark List Accent 6\"/>\n" +
                "            <w:lsdException w:name=\"Colorful Shading Accent 6\"/>\n" +
                "            <w:lsdException w:name=\"Colorful List Accent 6\"/>\n" +
                "            <w:lsdException w:name=\"Colorful Grid Accent 6\"/>\n" +
                "        </w:latentStyles>\n" +
                "        <w:style w:type=\"paragraph\" w:styleId=\"a1\" w:default=\"on\">\n" +
                "            <w:name w:val=\"Normal\"/>\n" +
                "            <w:pPr>\n" +
                "                <w:widowControl w:val=\"off\"/>\n" +
                "                <w:jc w:val=\"both\"/>\n" +
                "            </w:pPr>\n" +
                "            <w:rPr>\n" +
                "                <w:rFonts w:ascii=\"Calibri\" w:h-ansi=\"Calibri\" w:fareast=\"宋体\" w:cs=\"Times New Roman\" w:hint=\"default\"/>\n" +
                "                <w:kern w:val=\"2\"/>\n" +
                "                <w:sz w:val=\"21\"/>\n" +
                "                <w:sz-cs w:val=\"24\"/>\n" +
                "                <w:lang w:val=\"EN-US\" w:fareast=\"ZH-CN\"/>\n" +
                "            </w:rPr>\n" +
                "        </w:style>\n" +
                "        <w:style w:type=\"paragraph\" w:styleId=\"2\">\n" +
                "            <w:name w:val=\"heading 1\"/>\n" +
                "            <w:basedOn w:val=\"a1\"/>\n" +
                "            <w:next w:val=\"a1\"/>\n" +
                "            <w:pPr>\n" +
                "                <w:keepNext/>\n" +
                "                <w:keepLines/>\n" +
                "                <w:spacing w:before=\"340\" w:before-lines=\"0\" w:before-autospacing=\"off\" w:after=\"330\"\n" +
                "                           w:after-autospacing=\"off\" w:line=\"576\" w:line-rule=\"auto\"/>\n" +
                "                <w:outlineLvl w:val=\"0\"/>\n" +
                "            </w:pPr>\n" +
                "            <w:rPr>\n" +
                "                <w:b/>\n" +
                "                <w:kern w:val=\"44\"/>\n" +
                "                <w:sz w:val=\"44\"/>\n" +
                "            </w:rPr>\n" +
                "        </w:style>\n" +
                "        <w:style w:type=\"paragraph\" w:styleId=\"3\">\n" +
                "            <w:name w:val=\"heading 2\"/>\n" +
                "            <w:basedOn w:val=\"a1\"/>\n" +
                "            <w:next w:val=\"a1\"/>\n" +
                "            <w:pPr>\n" +
                "                <w:keepNext/>\n" +
                "                <w:keepLines/>\n" +
                "                <w:spacing w:before=\"260\" w:before-lines=\"0\" w:before-autospacing=\"off\" w:after=\"260\"\n" +
                "                           w:after-autospacing=\"off\" w:line=\"413\" w:line-rule=\"auto\"/>\n" +
                "                <w:outlineLvl w:val=\"1\"/>\n" +
                "            </w:pPr>\n" +
                "            <w:rPr>\n" +
                "                <w:rFonts w:ascii=\"Arial\" w:h-ansi=\"Arial\" w:fareast=\"黑体\" w:hint=\"default\"/>\n" +
                "                <w:b/>\n" +
                "                <w:sz w:val=\"32\"/>\n" +
                "            </w:rPr>\n" +
                "        </w:style>\n" +
                "        <w:style w:type=\"paragraph\" w:styleId=\"4\">\n" +
                "            <w:name w:val=\"heading 3\"/>\n" +
                "            <w:basedOn w:val=\"a1\"/>\n" +
                "            <w:next w:val=\"a1\"/>\n" +
                "            <w:pPr>\n" +
                "                <w:keepNext/>\n" +
                "                <w:keepLines/>\n" +
                "                <w:spacing w:before=\"260\" w:before-lines=\"0\" w:before-autospacing=\"off\" w:after=\"260\"\n" +
                "                           w:after-autospacing=\"off\" w:line=\"413\" w:line-rule=\"auto\"/>\n" +
                "                <w:outlineLvl w:val=\"2\"/>\n" +
                "            </w:pPr>\n" +
                "            <w:rPr>\n" +
                "                <w:b/>\n" +
                "                <w:sz w:val=\"32\"/>\n" +
                "            </w:rPr>\n" +
                "        </w:style>\n" +
                "        <w:style w:type=\"paragraph\" w:styleId=\"5\">\n" +
                "            <w:name w:val=\"heading 4\"/>\n" +
                "            <w:basedOn w:val=\"a1\"/>\n" +
                "            <w:next w:val=\"a1\"/>\n" +
                "            <w:pPr>\n" +
                "                <w:keepNext/>\n" +
                "                <w:keepLines/>\n" +
                "                <w:spacing w:before=\"280\" w:before-lines=\"0\" w:before-autospacing=\"off\" w:after=\"290\"\n" +
                "                           w:after-autospacing=\"off\" w:line=\"372\" w:line-rule=\"auto\"/>\n" +
                "                <w:outlineLvl w:val=\"3\"/>\n" +
                "            </w:pPr>\n" +
                "            <w:rPr>\n" +
                "                <w:rFonts w:ascii=\"Arial\" w:h-ansi=\"Arial\" w:fareast=\"黑体\" w:hint=\"default\"/>\n" +
                "                <w:b/>\n" +
                "                <w:sz w:val=\"28\"/>\n" +
                "            </w:rPr>\n" +
                "        </w:style>\n" +
                "        <w:style w:type=\"character\" w:styleId=\"a10\" w:default=\"on\">\n" +
                "            <w:name w:val=\"Default Paragraph Font\"/>\n" +
                "        </w:style>\n" +
                "        <w:style w:type=\"table\" w:styleId=\"a8\" w:default=\"on\">\n" +
                "            <w:name w:val=\"Normal Table\"/>\n" +
                "            <w:semiHidden/>\n" +
                "            <w:tblPr>\n" +
                "                <w:tblCellMar>\n" +
                "                    <w:top w:w=\"0\" w:type=\"dxa\"/>\n" +
                "                    <w:left w:w=\"108\" w:type=\"dxa\"/>\n" +
                "                    <w:bottom w:w=\"0\" w:type=\"dxa\"/>\n" +
                "                    <w:right w:w=\"108\" w:type=\"dxa\"/>\n" +
                "                </w:tblCellMar>\n" +
                "            </w:tblPr>\n" +
                "        </w:style>\n" +
                "        <w:style w:type=\"paragraph\" w:styleId=\"a6\">\n" +
                "            <w:name w:val=\"footer\"/>\n" +
                "            <w:basedOn w:val=\"a1\"/>\n" +
                "            <w:pPr>\n" +
                "                <w:tabs>\n" +
                "                    <w:tab w:val=\"center\" w:pos=\"4153\"/>\n" +
                "                    <w:tab w:val=\"right\" w:pos=\"8306\"/>\n" +
                "                </w:tabs>\n" +
                "                <w:snapToGrid w:val=\"off\"/>\n" +
                "                <w:jc w:val=\"left\"/>\n" +
                "            </w:pPr>\n" +
                "            <w:rPr>\n" +
                "                <w:sz w:val=\"18\"/>\n" +
                "            </w:rPr>\n" +
                "        </w:style>\n" +
                "        <w:style w:type=\"paragraph\" w:styleId=\"a7\">\n" +
                "            <w:name w:val=\"header\"/>\n" +
                "            <w:basedOn w:val=\"a1\"/>\n" +
                "            <w:pPr>\n" +
                "                <w:pBdr>\n" +
                "                    <w:top w:val=\"nil\"/>\n" +
                "                    <w:left w:val=\"nil\"/>\n" +
                "                    <w:bottom w:val=\"nil\"/>\n" +
                "                    <w:right w:val=\"nil\"/>\n" +
                "                </w:pBdr>\n" +
                "                <w:tabs>\n" +
                "                    <w:tab w:val=\"center\" w:pos=\"4153\"/>\n" +
                "                    <w:tab w:val=\"right\" w:pos=\"8306\"/>\n" +
                "                </w:tabs>\n" +
                "                <w:snapToGrid w:val=\"off\"/>\n" +
                "                <w:spacing w:line=\"240\" w:line-rule=\"auto\"/>\n" +
                "                <w:jc w:val=\"both\"/>\n" +
                "                <w:outlineLvl w:val=\"9\"/>\n" +
                "            </w:pPr>\n" +
                "            <w:rPr>\n" +
                "                <w:sz w:val=\"18\"/>\n" +
                "            </w:rPr>\n" +
                "        </w:style>\n" +
                "        <w:style w:type=\"table\" w:styleId=\"a9\">\n" +
                "            <w:name w:val=\"Table Grid\"/>\n" +
                "            <w:basedOn w:val=\"a8\"/>\n" +
                "            <w:pPr>\n" +
                "                <w:pStyle w:val=\"a8\"/>\n" +
                "                <w:widowControl w:val=\"off\"/>\n" +
                "                <w:jc w:val=\"both\"/>\n" +
                "            </w:pPr>\n" +
                "            <w:tblPr>\n" +
                "                <w:tblBorders>\n" +
                "                    <w:top w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                    <w:left w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                    <w:bottom w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                    <w:right w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                    <w:insideH w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                    <w:insideV w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                </w:tblBorders>\n" +
                "                <w:tblCellMar>\n" +
                "                    <w:top w:w=\"0\" w:type=\"dxa\"/>\n" +
                "                    <w:left w:w=\"108\" w:type=\"dxa\"/>\n" +
                "                    <w:bottom w:w=\"0\" w:type=\"dxa\"/>\n" +
                "                    <w:right w:w=\"108\" w:type=\"dxa\"/>\n" +
                "                </w:tblCellMar>\n" +
                "            </w:tblPr>\n" +
                "        </w:style>\n" +
                "    </w:styles>\n" +
                "    <w:bgPict>\n" +
                "        <w:background w:bgcolor=\"#FFFFFF\"/>\n" +
                "        <v:background id=\"_x0000_s1025\">\n" +
                "            <v:fill on=\"t\" focussize=\"0,0\"/>\n" +
                "        </v:background>\n" +
                "    </w:bgPict>\n" +
                "    <w:docPr>\n" +
                "        <w:view w:val=\"print\"/>\n" +
                "        <w:zoom w:percent=\"100\"/>\n" +
                "        <w:characterSpacingControl w:val=\"CompressPunctuation\"/>\n" +
                "        <w:documentProtection w:enforcement=\"off\"/>\n" +
                "        <w:displayBackgroundShape w:val=\"1\"/>\n" +
                "        <w:punctuationKerning/>\n" +
                "        <w:bordersDontSurroundHeader/>\n" +
                "        <w:bordersDontSurroundFooter/>\n" +
                "        <w:defaultTabStop w:val=\"420\"/>\n" +
                "        <w:drawingGridVerticalSpacing w:val=\"156\"/>\n" +
                "        <w:displayHorizontalDrawingGridEvery w:val=\"0\"/>\n" +
                "        <w:displayVerticalDrawingGridEvery w:val=\"2\"/>\n" +
                "        <w:compat>\n" +
                "            <w:adjustLineHeightInTable/>\n" +
                "            <w:ulTrailSpace/>\n" +
                "            <w:doNotExpandShiftReturn/>\n" +
                "            <w:balanceSingleByteDoubleByteWidth/>\n" +
                "            <w:useFELayout/>\n" +
                "            <w:spaceForUL/>\n" +
                "            <w:wrapTextWithPunct/>\n" +
                "            <w:breakWrappedTables/>\n" +
                "            <w:useAsianBreakRules/>\n" +
                "            <w:dontGrowAutofit/>\n" +
                "            <w:useFELayout/>\n" +
                "        </w:compat>\n" +
                "    </w:docPr>\n" +
                "    <w:body>\n" +
                "        <wx:sect>\n";
        return str;
    }
    public static String biaoge(TechnologyContent content){
        return "<w:tr>\n" +
                "                    <w:tblPrEx>\n" +
                "                        <w:tblBorders>\n" +
                "                            <w:top w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                            <w:left w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                            <w:bottom w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                            <w:right w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                            <w:insideH w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                            <w:insideV w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/>\n" +
                "                        </w:tblBorders>\n" +
                "                        <w:tblCellMar>\n" +
                "                            <w:top w:w=\"0\" w:type=\"dxa\"/>\n" +
                "                            <w:left w:w=\"108\" w:type=\"dxa\"/>\n" +
                "                            <w:bottom w:w=\"0\" w:type=\"dxa\"/>\n" +
                "                            <w:right w:w=\"108\" w:type=\"dxa\"/>\n" +
                "                        </w:tblCellMar>\n" +
                "                    </w:tblPrEx>\n" +
                "                    <w:trPr>\n" +
                "                        <w:trHeight w:val=\"756\" w:h-rule=\"atLeast\"/>\n" +
                "                    </w:trPr>\n" +
                "                    <w:tc>\n" +
                "                        <w:tcPr>\n" +
                "                            <w:tcW w:w=\"0\" w:type=\"auto\"/>\n" +
                "                            <w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"auto\"/>\n" +
                "                        </w:tcPr>\n" +
                "                        <w:p>\n" +
                "                            <w:pPr>\n" +
                "                                <w:spacing w:line=\"240\" w:line-rule=\"auto\"/>\n" +
                "                                <w:jc w:val=\"center\"/>\n" +
                "                                <w:rPr>\n" +
                "                                    <w:sz w:val=\"21\"/>\n" +
                "                                    <w:sz-cs w:val=\"21\"/>\n" +
                "                                </w:rPr>\n" +
                "                            </w:pPr>\n" +
                "                            <w:r>\n" +
                "                                <w:rPr>\n" +
                "                                    <w:rFonts w:hint=\"fareast\"/>\n" +
                "                                    <w:sz w:val=\"21\"/>\n" +
                "                                    <w:sz-cs w:val=\"21\"/>\n" +
                "                                </w:rPr>\n" +
                "                                <w:t>"+content.getKeyWord()+"</w:t>\n" +
                "                            </w:r>\n" +
                "                        </w:p>\n" +
                "                    </w:tc>\n" +
                "                    <w:tc>\n" +
                "                        <w:tcPr>\n" +
                "                            <w:tcW w:w=\"0\" w:type=\"auto\"/>\n" +
                "                            <w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"auto\"/>\n" +
                "                        </w:tcPr>\n" +
                "                        <w:p>\n" +
                "                            <w:pPr>\n" +
                "                                <w:spacing w:line=\"240\" w:line-rule=\"auto\"/>\n" +
                "                                <w:jc w:val=\"center\"/>\n" +
                "                                <w:rPr>\n" +
                "                                    <w:sz w:val=\"21\"/>\n" +
                "                                    <w:sz-cs w:val=\"21\"/>\n" +
                "                                </w:rPr>\n" +
                "                            </w:pPr>\n" +
                "                            <w:r>\n" +
                "                                <w:rPr>\n" +
                "                                    <w:rFonts w:hint=\"fareast\"/>\n" +
                "                                    <w:sz w:val=\"21\"/>\n" +
                "                                    <w:sz-cs w:val=\"21\"/>\n" +
                "                                </w:rPr>\n" +
                "                                <w:t>"+content.getFile()+"</w:t>\n" +
                "                            </w:r>\n" +
                "                        </w:p>\n" +
                "                    </w:tc>\n" +
                "                    <w:tc>\n" +
                "                        <w:tcPr>\n" +
                "                            <w:tcW w:w=\"0\" w:type=\"auto\"/>\n" +
                "                            <w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"auto\"/>\n" +
                "                        </w:tcPr>\n" +
                "                        <w:p>\n" +
                "                            <w:pPr>\n" +
                "                                <w:spacing w:line=\"240\" w:line-rule=\"auto\"/>\n" +
                "                                <w:jc w:val=\"center\"/>\n" +
                "                                <w:rPr>\n" +
                "                                    <w:sz w:val=\"21\"/>\n" +
                "                                    <w:sz-cs w:val=\"21\"/>\n" +
                "                                </w:rPr>\n" +
                "                            </w:pPr>\n" +
                "                            <w:r>\n" +
                "                                <w:rPr>\n" +
                "                                    <w:rFonts w:hint=\"fareast\"/>\n" +
                "                                    <w:sz w:val=\"21\"/>\n" +
                "                                    <w:sz-cs w:val=\"21\"/>\n" +
                "                                </w:rPr>\n" +
                "                                <w:t>"+content.getPosition()+"</w:t>\n" +
                "                            </w:r>\n" +
                "                        </w:p>\n" +
                "                    </w:tc>\n" +
                "                </w:tr>";
    }

    public static String createDocument(DocumentPage documentPage) {
        StringBuilder sb=new StringBuilder();
        //前面部分内容
        String standard = DocumentWordUtil.standard();
        String enddard = DocumentWordUtil.enddard();
        //标题内容
        String maintitle = DocumentWordUtil.Maintitle();
//        String subheading = DocumentWordUtil.subheading();
        //标题下的内容
        String standContent = DocumentWordUtil.content();
        //表格内容


        //页眉
        String header = documentPage.getHeader();
        String s1 = maintitle.replaceAll("#title#", header);
        sb.append(standard);
        sb.append(s1);
        List<TitleHead> titleHeads = documentPage.getTitleHeads();
        if(titleHeads!=null&&titleHeads.size()>0){
            for (TitleHead titleHead : titleHeads) {
                DocumentTitleEnum byCode = DocumentTitleEnum.getByCode(titleHead.getParentId());
                if (byCode != null) {
                    String titleContent = DocumentWordUtil.subheading(byCode);

                    //标题名称
                    String name = titleHead.getName();
                    if (!StringUtils.isEmpty(name)) {
                        //标题级别
                        int parentId = titleHead.getParentId();
                        String s = titleContent.replaceAll("#title#", name)
                                .replaceAll("#parentId#", String.valueOf(parentId));
                        sb.append(s);
                    }
                    List<DocumentContent> documentContents = titleHead.getDocumentContents();
                    if (documentContents != null && documentContents.size() > 0) {
                        for (DocumentContent documentContent : documentContents) {
                            if (documentContent != null) {
                                String content = documentContent.getContent();
                                String baseUrl = documentContent.getBaseUrl();
                                String documentTable = documentContent.getDocumentTable();
                                if (!StringUtils.isEmpty(content)) {
                                    String c = standContent;
                                    String s = c.replaceAll("#content#", content);
                                    sb.append(s);
                                }
                                if (!StringUtils.isEmpty(baseUrl)) {

                                }
                                if (!StringUtils.isEmpty(documentTable)) {
                                    sb.append(documentTable);
                                }
                            }
                        }
                    }
                }
            }
        }
        sb.append(enddard);
        return sb.toString();
    }
}
