package com.zjty.inspect.dao;

import com.zjty.inspect.entity.Rule;
import com.zjty.inspect.entity.RuleCollection;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

import java.util.List;

/**
 * @author mcj
 */
public interface RuleCollectionDao extends JpaRepository<RuleCollection, String>, JpaSpecificationExecutor<RuleCollection> {
    /**
     * 根据技术id以及关键字查询数据
     * @param technologyId 技术id
     * @param target 关键字
     * @return
     */
    RuleCollection findAllByTechnologyIdEqualsAndTargetEquals(String technologyId, String target);

    /**
     * 根据关键字查询数据
     * @param target 关键字
     * @return
     */
    List<RuleCollection> findAllByTargetLike(String target);
}
