package com.example.jpademo.service.impl;

import com.example.jpademo.dao.StudentDao;
import com.example.jpademo.pojo.Student;
import com.example.jpademo.service.StudentService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.util.List;
import java.util.Optional;

/**
 * @author: cnljj1995@gmail.com
 * @Date: 2022/5/6
 */
@Service
@Slf4j
public class StudentServiceImpl implements StudentService {

    @Autowired
    private StudentDao studentDao;

    @Override
    public Student findById(Integer id) {
        log.info("查找id为:{}的人", id);
        Optional<Student> one = studentDao.findById(id);
        Student student = new Student();
        student.setName("未找到");
        return one.orElse(student);
    }

    @Override
    public Student saveOne(Student student) {
        Student save = studentDao.save(student);
        return save;
    }

    @Override
    public List<Student> saveAll(List<Student> students) {
        return studentDao.saveAll(students);
    }

    @Override
    public void deleteById(List<Integer> ids) {
        studentDao.deleteAllById(ids);
    }
}
