package com.example.jpademo.controller;

import com.example.jpademo.pojo.Student;
import com.example.jpademo.service.StudentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author: cnljj1995@gmail.com
 * @Date: 2022/5/6
 */
@RestController
@RequestMapping("/model")
@Api(tags = "学生模块", description = "学生模块的接口信息")
public class StudentController {

    @Autowired
    private StudentService studentService;

    @GetMapping("/student")
    @ApiOperation(value = "根据学生id查找学生的接口")
    public ResponseEntity<Student> findOne(@RequestParam @ApiParam(value = "学生id", example = "10") Integer id) {
        return ResponseEntity.ok(studentService.findById(id));
    }

    @ApiOperation(value = "保存学生的接口")
    @PostMapping("/student")
    public Student saveOne(@RequestBody Student student) {
        return studentService.saveOne(student);
    }

    @PostMapping("/student/all")
    public List<Student> saveAll(@RequestBody List<Student> students) {
        return studentService.saveAll(students);
    }

    @DeleteMapping("/student")
    public ResponseEntity deleteAll(@RequestBody List<Integer> ids) {
        studentService.deleteById(ids);
        return ResponseEntity.status(402).body("已经删除了");
    }

}
