package com.example.jpademo.pojo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;

/**
 * @author: cnljj1995@gmail.com
 * @Date: 2022/5/6
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@ApiModel("人员信息")
public class Student {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(value = "主键id", example = "1")
    private Integer id;

    @ApiModelProperty(value = "姓名", example = "张三")
    private String name;

    @ApiModelProperty(value = "年龄", example = "15")
    private Integer age;

    @ApiModelProperty(value = "外键", example = "1")
    private Integer unionId;

    @Transient
    private Student student;
}
