package com.zjty.countunion.service;

import com.alibaba.fastjson.JSON;
import com.zjty.countunion.config.JacksonUtil;
import com.zjty.countunion.entity.PreCount;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.sql.*;
import java.util.ArrayList;
import java.util.List;

/**
 * @author LJJ cnljj1995@gmail.com
 * on 2020-09-04
 */
@Service
@Slf4j
public class TestService {

    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    public void tableCount() {

        String URL = "jdbc:mysql://zjtys.com.cn:3306/pre_dc?characterEncoding=utf-8";
        String USER = "root";
        String PASSWORD = "root";
        try {
            Class.forName("com.mysql.jdbc.Driver");
            Connection conn = DriverManager.getConnection(URL, USER, PASSWORD);
            String sql = "select table_name, table_rows from information_schema.tables where TABLE_SCHEMA = 'pre_dc'";
            PreparedStatement statement = conn.prepareStatement(sql);
            ResultSet rs = statement.executeQuery();
            List<PreCount> all = new ArrayList<>();
            List<PreCount> sharePreCounts = new ArrayList<>();
            List<PreCount> exchangePreCounts = new ArrayList<>();

            while (rs.next()) {
                all.add(new PreCount(rs.getString("table_name"), Long.valueOf(rs.getString("table_rows"))));
                log.info("{}",all);
            }

            all.forEach(o->{
                if (o.getTableName().split("")[0].equals("e")) {
                    String name = o.getTableName().replace("exchange_sjzx", "dc");
                    o.setTableName(name);
                    exchangePreCounts.add(o);
                } else if (o.getTableName().split("")[0].equals("s")) {
                    String name = o.getTableName().replace("share_sjzx", "dc");
                    o.setTableName(name);
                    sharePreCounts.add(o);
                }
            });
            log.info("打印:{}", sharePreCounts.toString());
            log.info("打印:{}", exchangePreCounts.toString());

            redisTemplate.opsForValue().set("a","a");

            //redisTemplate.opsForValue().set("exchange_count", JacksonUtil.toJSon(exchangePreCounts));
            redisTemplate.opsForValue().set("exchance_count", JSON.toJSONString(exchangePreCounts));
            //redisTemplate.opsForValue().set("share_count", JacksonUtil.toJSon(sharePreCounts));
            redisTemplate.opsForValue().set("share_count", JSON.toJSONString(sharePreCounts));

            // 关闭资源
            conn.close();
            rs.close();
            statement.close();
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

}
