package com.zjty.countunion.task;

import com.zjty.countunion.service.TestService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * @author LJJ cnljj1995@gmail.com
 * on 2020-09-04
 */
@Component
@Slf4j
public class Runner {

    @Autowired
    private TestService testService;

    /**
     * 3分钟执行一次
     */
    @Scheduled(initialDelay = 4000, fixedRate = 60000 * 3)
    public void count() {
        log.info("执行定时任务");
        testService.tableCount();
    }
}
