package com.zjty.countunion.service;

import com.alibaba.fastjson.JSON;
import com.zjty.countunion.config.JacksonUtil;
import com.zjty.countunion.entity.PreCount;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.sql.*;
import java.util.ArrayList;
import java.util.List;

/**
 * @author LJJ cnljj1995@gmail.com
 * on 2020-09-04
 */
@Service
@Slf4j
public class TestService {

    @Autowired
    private RedisTemplate<String, Object> defaultRedisTpl;

    @Value("${spring.datasource.url}")
    private String URL;

    @Value("${spring.datasource.username}")
    private String USER;

    @Value("${spring.datasource.password}")
    private String PASSWORD;

    public void tableCount() {
        try {
            Class.forName("com.mysql.jdbc.Driver");
            Connection conn = DriverManager.getConnection(URL, USER, PASSWORD);
            String sql = "select table_name, table_rows from information_schema.tables where TABLE_SCHEMA = 'pre_dc'";
            PreparedStatement statement = conn.prepareStatement(sql);
            ResultSet rs = statement.executeQuery();
            List<PreCount> all = new ArrayList<>();
            List<PreCount> sharePreCounts = new ArrayList<>();
            List<PreCount> exchangePreCounts = new ArrayList<>();

            while (rs.next()) {
                all.add(new PreCount(rs.getString("table_name"), Long.valueOf(rs.getString("table_rows"))));
                log.info("{}",all);
            }

            all.forEach(o->{
                if (o.getTableName().split("")[0].equals("e")) {
                    String name = o.getTableName().replace("exchange_sjzx", "dc");
                    o.setTableName(name);
                    exchangePreCounts.add(o);
                } else if (o.getTableName().split("")[0].equals("s")) {
                    String name = o.getTableName().replace("share_sjzx", "dc");
                    o.setTableName(name);
                    sharePreCounts.add(o);
                }
            });
            log.info("打印:{}", sharePreCounts.toString());
            log.info("打印:{}", exchangePreCounts.toString());

            defaultRedisTpl.opsForValue().set("exchange_count", JSON.toJSONString(exchangePreCounts));
            defaultRedisTpl.opsForValue().set("share_count", JSON.toJSONString(sharePreCounts));

            // 关闭资源
            conn.close();
            rs.close();
            statement.close();
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

}
