package com.zjty.vms.inspection.controller;

import com.zjty.vms.inspection.entity.dto.ReportSearchDto;
import com.zjty.vms.inspection.service.ReportService;
import com.zjty.vms.inspection.entity.po.Report;
import com.zjty.vms.inspection.entity.dto.ReportDto;
import com.zjty.vms.misc.entity.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * @author xyy
 */
@Api(tags = "违停举报")
@RestController
@RequestMapping("report")
public class ReportController {

    @Resource
    private ReportService reportService;

    @PostMapping("save")
    @ApiModelProperty("新增或修改")
    public Report save(@RequestBody ReportDto reportDto) {
        return reportService.save(reportDto);
    }

    @PostMapping("search")
    @ApiModelProperty("查询")
    public PageResult<Report> search(@RequestBody ReportSearchDto reportSearchDto) {
        return reportService.search(reportSearchDto);
    }

    @DeleteMapping
    @ApiModelProperty("删除")
    public void delete(String id) {
        reportService.delete(id);
    }

}
