package com.zjty.vms.inspection.service.impl;

import com.github.wenhao.jpa.Specifications;
import com.zjty.vms.inspection.dao.ReportRepository;
import com.zjty.vms.inspection.entity.dto.ReportDto;
import com.zjty.vms.inspection.entity.dto.ReportSearchDto;
import com.zjty.vms.inspection.entity.po.Report;
import com.zjty.vms.inspection.service.ReportService;
import com.zjty.vms.inspection.service.converter.ReportConverter;
import com.zjty.vms.misc.entity.PageResult;
import com.zjty.vms.misc.util.StringUtil;
import com.zjty.vms.user.subject.entity.User;
import com.zjty.vms.user.subject.service.UserService;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Objects;
import java.util.Optional;

/**
 * @author xyy
 */
@Service
public class ReportServiceImpl implements ReportService {

    @Resource
    private ReportConverter reportConverter;

    @Resource
    private ReportRepository reportRepository;

    @Resource
    private UserService userService;

    @Override
    public Report save(ReportDto reportDto) {
        Report report = reportConverter.toReport(reportDto);

        //存在Id
        if (StringUtil.isNotBlank(reportDto.getId())) {
            Optional<Report> reportOptional = reportRepository.findById(reportDto.getId());
            if (reportOptional.isPresent()) {
                BeanUtils.copyProperties(report, reportOptional.get());
                report = reportOptional.get();
            }
        }

        return reportRepository.save(report);
    }

    @Override
    public PageResult<Report> search(ReportSearchDto reportSearchDto) {
        Optional<User> user = userService.currentUser();
        Specification<Report> specifications = Specifications.<Report>and()
                .eq(user.isPresent(), "userId", user.get().getId())
                .eq(!Objects.isNull(reportSearchDto.getHandleProcessType()), "handleProcess", reportSearchDto.getHandleProcessType())
                .build();
        Pageable pageable = PageRequest.of(reportSearchDto.getPageNum() - 1, reportSearchDto.getPageSize(), Sort.Direction.DESC, "reportDate");
        Page<Report> userAll = reportRepository.findAll(specifications, pageable);

        return PageResult.pageToPageResult(userAll);
    }

    @Override
    public void delete(String id) {
        reportRepository.deleteById(id);
    }
}
