package com.zjty.vms.maintain.entity.po;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.SQLDeleteAll;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;

/**
 * @author xyy
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update common_maintain set del_flag = 1 where id = ?")
@SQLDeleteAll(sql = "update common_maintain set del_flag = 1 where id = ?")
@Where(clause = "del_flag = 0")
public class CommonMaintain {

    @Id
    @GenericGenerator(name = "idGenerator", strategy = "uuid")
    @GeneratedValue(generator = "idGenerator")
    private String id;

    @ApiModelProperty("用户id")
    @CreatedBy
    private String userId;



    @ApiModelProperty(value = "删除标识", notes = "true: 已删除, false: 未删除")
    @Column(columnDefinition = "boolean default false")
    @JsonIgnore
    private Boolean delFlag;
}
