package com.zjty.vms.user.subject.dao;

import com.zjty.vms.user.subject.entity.User;
import org.springframework.data.jpa.repository.JpaRepository;

import java.util.Optional;

/**
 * @author xyy
 */
public interface UserRepository extends JpaRepository<User, String> {

    /**
     * 通过电话号查询用户
     * @param phoneNum 电话号
     * @return 用户
     */
    Optional<User> findByPhoneNum(String phoneNum);

    /**
     * 通过微信小程序唯一id查找用户
     * @param openId openId
     * @return 用户
     */
    Optional<User> findByOpenId(String openId);
}
