package com.zjty.vms.user.subject.service.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.bean.WxMaPhoneNumberInfo;
import cn.binarywang.wx.miniapp.bean.WxMaUserInfo;
import com.zjty.vms.user.config.security.JwtTokenUtils;
import com.zjty.vms.user.subject.dao.UserRepository;
import com.zjty.vms.user.subject.entity.User;
import com.zjty.vms.user.subject.service.UserService;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/**
 * @author xyy
 */
@Slf4j
@Service
public class UserServiceImpl implements UserService {

    @Resource
    private UserRepository userRepository;
    @Resource
    private WxMaService wxMaService;

    @Override
    public User save(User user) {
        return userRepository.save(user);
    }

    @Override
    public Optional<User> findByPhoneNum(String phoneNum) {
        return userRepository.findByPhoneNum(phoneNum);
    }

    @Override
    public Map<String, String> login(String code) {
        Map<String, String> map = new HashMap<>(4);
        try {
            WxMaJscode2SessionResult session = wxMaService.getUserService().getSessionInfo(code);
            map.put("sessionKey", session.getSessionKey());
            UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken(session.getOpenid(), null, null);

            //判断是否为新用户
            Optional<User> userOptional = userRepository.findByOpenId(session.getOpenid());
            if (!userOptional.isPresent()) {
                User user = User.builder()
                        .openId(session.getOpenid())
                        .build();
                save(user);
            }
            String token = JwtTokenUtils.generateToken(authenticationToken);
            map.put("token", token);
        } catch (WxErrorException e) {
            log.error(e.getMessage(), e);
        }
        return map;
    }

    @Override
    public Optional<User> currentUser() {
//        return findByOpenId("oOO7F5J7RLT7Tp78WEqV3MLN3f7k");
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        //有登陆用户就返回登录用户，没有就返回null
        if (authentication != null) {
            if (authentication instanceof AnonymousAuthenticationToken) {
                return Optional.empty();
            }

            if (authentication instanceof UsernamePasswordAuthenticationToken) {
                String openId = authentication.getPrincipal().toString();
                return findByOpenId(openId);
            }
        }
        return Optional.empty();
    }

    @Override
    public String getPhone(String sessionKey, String signature, String rawData, String encryptedData, String iv) {

        // 用户信息校验
        if (!wxMaService.getUserService().checkUserInfo(sessionKey, rawData, signature)) {
            throw new IllegalArgumentException("参数异常");
        }

        // 解密
        WxMaPhoneNumberInfo phoneNoInfo = wxMaService.getUserService().getPhoneNoInfo(sessionKey, encryptedData, iv);

        return phoneNoInfo.getPhoneNumber();
    }

    @Override
    public User getInfo(String sessionKey, String signature, String rawData, String encryptedData, String iv) {

        // 用户信息校验
        if (!wxMaService.getUserService().checkUserInfo(sessionKey, rawData, signature)) {
            throw new IllegalArgumentException("参数异常");
        }

        // 解密用户信息
        WxMaUserInfo userInfo = wxMaService.getUserService().getUserInfo(sessionKey, encryptedData, iv);

        User user = User.builder()
                .username(userInfo.getNickName())
                .build();
        return user;
    }

    private Optional<User> findByOpenId(String openId) {
        Optional<User> userOptional = userRepository.findByOpenId(openId);
        return userOptional;
    }

}
