package com.zjty.vms.inspection.entity.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.GeneratedValue;
import javax.persistence.Id;

/**
 * @author xyy
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ReportDto {

    @Id
    @GenericGenerator(name = "idGenerator", strategy = "uuid")
    @GeneratedValue(generator = "idGenerator")
    private String id;

    @ApiModelProperty("举报类型")
    private String type;

    @ApiModelProperty("车牌号")
    private String licensePlateNum;

    @ApiModelProperty("事发地址")
    private String address;

    @ApiModelProperty("匿名标识")
    private boolean anonymous;

    @ApiModelProperty("描述内容")
    private String content;

    @ApiModelProperty("近景照片")
    private String nearlyPhoto;

    @ApiModelProperty("远景照片")
    private String farPhoto;

    @ApiModelProperty("其他照片")
    private String otherPhoto;

}
