package com.zjty.vms.inspection.entity.po;


import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.SQLDeleteAll;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.time.LocalDate;

/**
 * @author xyy
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update report set del_flag = 1 where id = ?")
@SQLDeleteAll(sql = "update report set del_flag = 1 where id = ?")
@Where(clause = "del_flag = 0")
public class Report {

    @Id
    @GenericGenerator(name = "idGenerator", strategy = "uuid")
    @GeneratedValue(generator = "idGenerator")
    private String id;

    @ApiModelProperty("用户id")
    @CreatedBy
    private String userId;

    @ApiModelProperty("举报类型")
    private String type;

    @ApiModelProperty("车牌号")
    private String licensePlateNum;

    @ApiModelProperty("事发地址")
    private String address;

    @ApiModelProperty("匿名标识")
    @Column(columnDefinition = "boolean default false")
    private Boolean anonymous;

    @ApiModelProperty("描述内容")
    private String content;

    @ApiModelProperty("上报日期")
    @CreatedDate
    private LocalDate reportDate;

    @ApiModelProperty(value = "处理进度", notes = "0:未处理, 1:处理中, 2: 已处理")
    private Integer handleProcess;

    @ApiModelProperty("近景照片")
    private String nearlyPhoto;

    @ApiModelProperty("远景照片")
    private String farPhoto;

    @ApiModelProperty("其他照片")
    private String otherPhoto;

    @ApiModelProperty("评价")
    private String evaluation;

    @ApiModelProperty("反馈")
    private String feedback;

    @ApiModelProperty(value = "删除标识", notes = "true: 已删除, false: 未删除")
    @Column(columnDefinition = "boolean default false")
    @JsonIgnore
    private Boolean delFlag;

}