package com.zjty.vms.user.config.jpa;

import com.zjty.vms.user.config.exception.UserException;
import com.zjty.vms.user.config.exception.UserExceptionConsts;
import com.zjty.vms.user.subject.entity.User;
import com.zjty.vms.user.subject.service.UserService;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.domain.AuditorAware;

import javax.annotation.Resource;
import java.util.Optional;

/**
 * @author xyy
 */
@Configuration
public class UseridAuditorBean implements AuditorAware<String> {

    @Resource
    private UserService userService;

    @Override
    public Optional<String> getCurrentAuditor() {
        Optional<User> user = userService.currentUser();
        if(user.isPresent()) {
            return Optional.of(user.get().getId());
        }
        throw new UserException(UserExceptionConsts.NO_CURRENT_USER);
    }

}
