package com.zjty.vms.user.config.security;

import com.zjty.vms.misc.util.JsonUtil;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.CorsUtils;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

import java.io.PrintWriter;

/**
 * @author xyy
 */
@Configuration
public class SecurityConfig extends WebSecurityConfigurerAdapter {

    @Override
    protected void configure(HttpSecurity http) throws Exception {
        //前后端分离前端不会302重定向，所以要重写AuthenticationEntryPoint
        http.cors().and()
                .csrf().disable()
                .authorizeRequests()//开启登录配置
                //处理跨域请求中的Preflight请求
                .requestMatchers(CorsUtils::isPreFlightRequest).permitAll()
                .antMatchers("/").permitAll()
                .anyRequest().authenticated()//表示剩余的其他接口，登录之后就能访问
                .and()
                .formLogin()
                //登录处理接口
                .loginProcessingUrl("/login")
                .permitAll()//和表单登录相关的接口统统都直接通过
                .and()
                .logout()
                .logoutUrl("/logout")
                .logoutSuccessHandler((req, resp, authentication) -> {
                    resp.setContentType("application/json;charset=utf-8");
                    resp.setCharacterEncoding("utf-8");
                    resp.setContentType("text/html; charset=utf-8");
                    PrintWriter out = resp.getWriter();
                    out.write("logout success");
                    out.flush();
                })
                .permitAll()
                .and()
                .exceptionHandling()
                .accessDeniedHandler((req, resp, e) -> {
                    // Ser result = Result.ERROR(ResultCode.NO_PERMISSION);
                    resp.setCharacterEncoding("utf-8");
                    resp.setContentType("text/html; charset=utf-8");
                    PrintWriter out = resp.getWriter();
                    out.write(JsonUtil.toJson("认证失败"));
                    out.flush();
                    out.close();
                })
                .authenticationEntryPoint((req, resp, e) -> {
                    // Result result = Result.ERROR(ResultCode.USER_NOT_LOGIN);
                    resp.setCharacterEncoding("utf-8");
                    resp.setContentType("text/html; charset=utf-8");
                    PrintWriter out = resp.getWriter();
                    out.write(JsonUtil.toJson("认证失败"));
                    out.flush();
                    out.close();
                })
                .and()
                .httpBasic();
        // 开启登录认证流程过滤器
        http.addFilterBefore(new JwtLoginFilter(authenticationManager()), UsernamePasswordAuthenticationFilter.class);
        // 访问控制时登录状态检查过滤器
        http.addFilterBefore(new JwtAuthenticationFilter(authenticationManager()), UsernamePasswordAuthenticationFilter.class);
    }

    @Override
    public void configure(WebSecurity web) throws Exception {
        web.ignoring().antMatchers("/v2/api-docs", "/swagger-resources/configuration/ui",
                "/swagger-resources", "/swagger-resources/configuration/security",
                "/swagger-ui.html", "/webjars/**", "/csrf",
                "/js/**","/css/**","/favicon.ico","/index.html","/fonts/**",
                "/static/**"
        ).and().ignoring().antMatchers(HttpMethod.GET, "/user/login");
    }

    @Bean
    CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.addAllowedOriginPattern("*");
        configuration.addAllowedMethod("*");
        configuration.addAllowedHeader("*");
        configuration.setAllowCredentials(true);
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return source;
    }
}