package com.zjty.vms.user.subject.controller;

import com.zjty.vms.user.subject.entity.User;
import com.zjty.vms.user.subject.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @author xyy
 */
@Api(tags = "用户管理")
@Slf4j
@RestController
@RequestMapping("user")
public class UserController {

    @Resource
    private UserService userService;

    /**
     * 登陆接口
     */
    @GetMapping("/login")
    @ApiModelProperty("用户登录")
    public Map<String, String> login(String jsCode) {
        return userService.login(jsCode);
    }

    /**
     * <pre>
     * 获取用户信息接口
     * </pre>
     */
    @GetMapping("/info")
    @ApiModelProperty("获取用户信息接口")
    public User info(@PathVariable String appid, String sessionKey,
                     String signature, String rawData, String encryptedData, String iv) {
        return userService.getInfo(sessionKey, signature, rawData, encryptedData, iv);
    }

    /**
     * <pre>
     * 获取用户绑定手机号信息
     * </pre>
     */
    @GetMapping("/phone")
    @ApiModelProperty("获取用户绑定手机号信息")
    public String phone(@PathVariable String appid, String sessionKey, String signature,
                        String rawData, String encryptedData, String iv) {
        return userService.getPhone(sessionKey, signature, rawData, encryptedData, iv);
    }
}
