package com.zjty.vms.user.subject.service;

import com.zjty.vms.user.subject.entity.User;

import java.util.Map;
import java.util.Optional;

/**
 * @author xyy
 */
public interface UserService {

    /**
     * 新增用户
     * @param user 用户
     * @return 用户
     */
    User save(User user);

    /**
     * 通过手机号查询用户
     * @param phoneNum 手机号
     * @return 用户
     */
    Optional<User> findByPhoneNum(String phoneNum);

    /**
     * 用户登录
     * @param code 小程序登录code
     * @return 返回token
     */
    Map<String, String> login(String code);

    /**
     * 当前用户
     * @return user
     */
    Optional<User> currentUser();

    /**
     * 获取用户手机号
     * @param sessionKey sessionKey
     * @param signature signature
     * @param rawData rawData
     * @param encryptedData encryptedData
     * @param iv iv
     * @return 手机号
     */
    String getPhone(String sessionKey, String signature, String rawData, String encryptedData, String iv);

    /**
     * 获取用户信息
     * @param sessionKey sessionKey
     * @param signature signature
     * @param rawData rawData
     * @param encryptedData encryptedData
     * @param iv iv
     * @return user
     */
    User getInfo(String sessionKey, String signature, String rawData, String encryptedData, String iv);
}
