package com.zjty.project.inspect.controller;

import com.zjty.project.inspect.service.CategoryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping("/category")
@Api(value = "类型管理接口",description = "类型管理接口,提供页面的增、删、改、查")
public class CategoryCotroller {
    @Autowired
    private CategoryService categoryService;

    /**
     * 查询所有类型
     * @return
     */
    @ApiOperation("查询所有类型")
    @GetMapping
    public ResponseEntity getCategorys(){
        return ResponseEntity.ok(categoryService.findAll());
    }
}
