package com.zjty.project.inspect.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * <h4>Description : 中间件难度</h4>
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 * @Date : 2020-03-05 19:30
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "中间件难度")
public class MiddlewareDifficulty {
    /**
     * 系统评估
     */
    private double systemEvaluation;

    /**
     * 额外信息
     */
    private double message;

    /**
     * 综合难度
     */
    private double difficulty;

    /**
     * 工作量
     */
    private double load;

    /**
     * 依赖详情(国产化支持的，王永磊要用)
     */
    @ApiModelProperty(value = "依赖详情",example = "1")
    private Integer dependOnNum;

    /**
     * 依赖数量
     */
    @ApiModelProperty(value = "依赖数量",example = "1")
    private Integer number;
    /*
     *用户额外信息详情
     */
    /**
     *Web集群 1:是 2：否
     */
    @ApiModelProperty(value = "Web集群 1:是 2：否",example = "1")
    private Integer web;

    /**
     * Jndi集群 1:是 2：否
     */
    @ApiModelProperty(value = "Jndi集群 1:是 2：否",example = "1")
    private Integer jndi;

    /**
     * Jms集群 1:是 2：否
     */
    @ApiModelProperty(value = "Jms集群 1:是 2：否",example = "1")
    private Integer jms;

    /**
     * 消息路由 1:是 2：否
     */
    @ApiModelProperty(value = "消息路由 1:是 2：否",example = "1")
    private Integer route;

}
