package com.zjty.project.inspect.service.impl;

import com.zjty.project.inspect.dao.ConfigParamDao;
import com.zjty.project.inspect.entity.Config;
import com.zjty.project.inspect.service.ConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Service
@Transactional(rollbackFor = Exception.class)
public class ConfigServiceImpl implements ConfigService {

    @Autowired
    private ConfigParamDao configParamDao;
    @Override
    public void updateConfig(List<Config> configs) {
        List<Config> configList=new ArrayList<>();
        for (Config config : configs) {
            Optional<Config> optional = configParamDao.findById(config.getId());
            if (optional.isPresent()) {
                Config c = optional.get();
                c.setValue(config.getValue());
                configList.add(c);
            }
        }
        configParamDao.saveAll(configList);

    }

    @Override
    public List<Config> findAll() {
        return configParamDao.findAll();
    }
}
