package com.zjty.project.state.config.advice;

import com.zjty.project.state.base.exception.MyException;
import com.zjty.project.state.base.response.ResponseCode;
import com.zjty.project.state.base.response.ServerResponse;
import com.zjty.project.state.base.result.ExceptionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

/**
 * @program: bserver
 * @description:  自定义全局异常处理
 * @author: LiuJie
 * @create: 2019-05-15 11:27
 **/

@RestControllerAdvice
public class CommonExceptionHandler {
    private final Logger logger =  LoggerFactory.getLogger(this.getClass());

    /**
     * 自定义全局异常处理方法
     * @param myException
     * @return
     */
//    @ExceptionHandler({Exception.class})
//    public ServerResponse<ExceptionResult> handleException(ResponseCode code){
//        logger.error("errorExceptionResult:{}", JSON.toJSONString(code));
//        return ServerResponse.error(code.getCode(),code.getMsg(),new ExceptionResult(code));
//    }
    @ExceptionHandler({MyException.class})
    public ServerResponse<ExceptionResult> handleException(MyException myException) {
        ResponseCode code = myException.getResponseCode();
        String message = myException.getMessage();
        logger.error("myException-code:{}", code.getMsg());
        logger.error("myException-message:{}", message);
        return ServerResponse.error(code.getCode(), code.getMsg(), new ExceptionResult(code));
    }
}

