package com.zjty.project.state.server.controller;

import com.zjty.project.state.base.exception.MyException;
import com.zjty.project.state.base.response.ResponseCode;
import com.zjty.project.state.base.response.ServerResponse;
import com.zjty.project.state.server.pojo.complain.Complain;
import com.zjty.project.state.server.pojo.user.User;
import com.zjty.project.state.server.service.ComplainService;
import com.zjty.project.state.utils.BaseRequest;
import com.zjty.project.state.utils.ExceptionMessage;
import com.zjty.project.state.utils.LoginedUserPool;
import com.zjty.project.state.utils.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;

/**
 * @program: demo
 * @description:
 * @author: LiuJie
 * @create: 2020-02-13 16:04
 **/
@Api(description = "ComplainController投诉接口")
@RestController
@RequestMapping("/complain")
public class ComplainController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ComplainService complainService;

    
    @ApiOperation(value = "投诉分页查询", notes = "投诉分页查询")
    @RequestMapping(value = "/search", method = RequestMethod.POST)
    public ServerResponse search(@RequestBody BaseRequest<Complain> baseRequest) throws Exception{
        try {
            PageResult<Complain> pageResult= complainService.search(baseRequest);
            return ServerResponse.success(pageResult);
        }catch (MyException myException) {
            throw myException;
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("投诉分页查询失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }
    }

    @ApiOperation(value = "投诉新增", notes = "投诉新增")
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ServerResponse add(HttpServletRequest request,@RequestBody Complain complain) throws Exception{
        try {
            String loginSession = request.getHeader("session");
            User user = LoginedUserPool.get(loginSession);
            if (user!=null){
                complain.setUserId(user.getId());
                complain.setPhone(user.getNumber());
                complain.setTime(new Date());
                complainService.add(complain);
                return ServerResponse.success("投诉成功。");
            }else {
                complain.setUserId(1);
                complain.setPhone("18776656545");
                complainService.add(complain);
                return ServerResponse.success("投诉成功。");
//                throw new MyException(ResponseCode.USER_NOT_LOGIN);
            }

        }catch (MyException myException) {
            throw myException;
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("投诉新增失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }
    }


    @ApiOperation(value = "投诉回复、设为重要、置顶操作", notes = "投诉回复、设为重要、置顶操作")
    @RequestMapping(value = "/update", method = RequestMethod.PUT)
    public ServerResponse update(@RequestBody Complain complain) throws Exception{
        try {
            complainService.update(complain);
            return ServerResponse.success("操作成功。");
        }catch (MyException myException) {
            throw myException;
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("投诉新增失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }
    }
    @ApiOperation(value = "分页查询自己的投诉历史", notes = "分页查询自己的投诉历史")
    @RequestMapping(value = "/searchSelf", method = RequestMethod.POST)
    public ServerResponse searchSelf(HttpServletRequest request,@RequestBody BaseRequest<Complain> baseRequest) throws Exception{
        try {
            String loginSession = request.getHeader("session");
            User user = LoginedUserPool.get(loginSession);
            Complain complain = baseRequest.getT();
            if (complain==null){
                complain = new Complain();
            }
            if (user!=null){
                complain.setUserId(user.getId());
                PageResult<Complain> pageResult= complainService.search(baseRequest);
                return ServerResponse.success(pageResult);
            }else {
                complain.setUserId(1);
                PageResult<Complain> pageResult= complainService.search(baseRequest);
                return ServerResponse.success(pageResult);
//                throw new MyException(ResponseCode.USER_NOT_LOGIN);
            }
        }catch (MyException myException) {
            throw myException;
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("分页查询自己的投诉历史失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }
    }

}
