package com.zjty.project.state.server.controller;

import com.zjty.project.state.base.exception.MyException;
import com.zjty.project.state.base.response.ResponseCode;
import com.zjty.project.state.base.response.ServerResponse;
import com.zjty.project.state.server.pojo.project.Project;
import com.zjty.project.state.server.pojo.user.User;
import com.zjty.project.state.server.service.ProjectService;
import com.zjty.project.state.utils.BaseRequest;
import com.zjty.project.state.utils.ExceptionMessage;
import com.zjty.project.state.utils.LoginedUserPool;
import com.zjty.project.state.utils.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@Api(tags = "ProjectController项目管理接口")
@RestController
@RequestMapping("/project")
public class ProjectController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ProjectService projectService;
    @ApiOperation(value = "项目新增")
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ServerResponse addProject(HttpServletRequest request, @RequestBody Project project){
        try {
            String loginSession = request.getHeader("session");
            User user = LoginedUserPool.get(loginSession);
            if (user!=null){
                projectService.addProject(project,user);
                return ServerResponse.success("新建项目成功。");
            }else {
                throw new MyException(ResponseCode.USER_NOT_LOGIN);
            }
        }catch (MyException myException) {
            throw myException;
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("新建项目失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }

    }
//    @ApiOperation(value = "修改项目")
//    @PostMapping("/modify")
//    public ServerResponse modify(@RequestBody Project project){
//        return projectService.modify(project);
//    }
//    @ApiOperation(value = "删除项目")
//    @PostMapping("/delete")
//    public ServerResponse delete(@RequestBody Project project){
//        return projectService.delete(project);
//    }
//    @ApiOperation(value = "分页查询")
//    @PostMapping("/page/{size}/{page}")
//    public ServerResponse page(@RequestBody Project project, @PathVariable("page")Integer page, @PathVariable("size")Integer size){
//        return projectService.page(project,page,size);
//    }
//    @ApiOperation(value = "获取所有项目")
//    @GetMapping("/findAll")
//    public ServerResponse findAll(){
//        return ServerResponse.success(projectService.findAll());
//    }
//
//    @ApiOperation(value = "为项目绑定微服务")
//    @PostMapping("/addMicroServer")
//    public ServerResponse addMicroServer(int id, List<Integer> serverIdList){
//        return projectService.addMicroServer(id,serverIdList);
//    }
//

    @ApiOperation(value = "根据项目id，获取项目技术路线", notes = "根据项目id，获取项目技术路线")
    @RequestMapping(value = "/getTech/{id}", method = RequestMethod.GET)
    public ServerResponse getTech(@PathVariable("id") Integer id){
        try {
            if (id!=null&&id>0){
                return ServerResponse.success(projectService.getTech(id));
            }else {
                throw new MyException(ResponseCode.PROJECT_ID_IS_NULL);
            }
        }catch (MyException myException) {
            throw myException;
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("项目产品清单分页查询失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }
    }

    @ApiOperation(value = "根据项目id，查看项目信息", notes = "根据项目id，查看项目信息")
    @RequestMapping(value = "/get/{id}", method = RequestMethod.GET)
    public ServerResponse get(@PathVariable("id") Integer id){
        try {
            if (id!=null&&id>0){
                return ServerResponse.success(projectService.get(id));
            }else {
                throw new MyException(ResponseCode.PROJECT_ID_IS_NULL);
            }
        }catch (MyException myException) {
            throw myException;
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("根据项目id，查看项目信息失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }
    }



    @ApiOperation(value = "项目分页查询", notes = "项目分页查询")
    @RequestMapping(value = "/search", method = RequestMethod.POST)
    public ServerResponse search(HttpServletRequest request,@RequestBody BaseRequest<Project> baseRequest){
        try {
            String loginSession = request.getHeader("session");
            User user = LoginedUserPool.get(loginSession);
            if (user!=null){
                PageResult<Project> pageResult= projectService.search(baseRequest);
                return ServerResponse.success(pageResult);
            }else {
                throw new MyException(ResponseCode.USER_NOT_LOGIN);
            }
        }catch (MyException myException) {
            throw myException;
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("项目分页查询失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }
    }

    @ApiOperation(value = "本单位项目分页查询", notes = "本单位项目分页查询")
    @RequestMapping(value = "/searchSelf", method = RequestMethod.POST)
    public ServerResponse searchSelf(HttpServletRequest request,@RequestBody BaseRequest<Project> baseRequest){
        try {
            String loginSession = request.getHeader("session");
            User user = LoginedUserPool.get(loginSession);
            if (user!=null){
                Project project = baseRequest.getT();
                if (project==null){
                    project = new Project();
                }
                Integer unitId = user.getUnitId();
                project.setConsId(unitId);
                PageResult<Project> pageResult= projectService.search(baseRequest);
                return ServerResponse.success(pageResult);
            }else {
                throw new MyException(ResponseCode.USER_NOT_LOGIN);
            }
        }catch (MyException myException) {
            throw myException;
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("本单位项目分页查询失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }
    }


    @ApiOperation(value = "获取所有的项目", notes = "获取所有的项目")
    @RequestMapping(value = "/findAll", method = RequestMethod.GET)
    public ServerResponse findAll(){
        try {
            List<Project> projectList = projectService.findAll();
            return ServerResponse.success(projectList);
        }catch (MyException myException) {
            throw myException;
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("获取所有的项目失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }
    }


}
