package com.zjty.project.state.server.controller;

import com.zjty.project.state.base.exception.MyException;
import com.zjty.project.state.base.response.ResponseCode;
import com.zjty.project.state.base.response.ServerResponse;
import com.zjty.project.state.server.pojo.user.Role;
import com.zjty.project.state.server.service.RoleService;
import com.zjty.project.state.utils.BaseRequest;
import com.zjty.project.state.utils.ExceptionMessage;
import com.zjty.project.state.utils.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @program: demo
 * @description:
 * @author: LiuJie
 * @create: 2020-02-13 16:04
 **/
@Api(description = "RoleController角色接口")
@RestController
@RequestMapping("/role")
public class RoleController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private RoleService roleService;

    @ApiOperation(value = "新建角色", notes = "新建角色，同时选着该角色拥有的权利集合")
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ServerResponse<String> add(@RequestBody Role role) throws Exception{
        try {
            roleService.add(role);
        }catch (MyException myException) {
            throw myException;
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("新建角色失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);

        }
        return ServerResponse.success("新建角色成功。");
    }

    @ApiOperation(value = "角色分页查询", notes = "角色分页查询：根据角色名查询角色列表")
    @RequestMapping(value = "/search", method = RequestMethod.POST)
    public ServerResponse< PageResult<Role> > search(@RequestBody BaseRequest<Role> baseRequest) throws Exception{
        try {
            PageResult<Role> pageResult= roleService.search(baseRequest);
            return ServerResponse.success(pageResult);
        }catch (MyException myException) {
            throw myException;
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("角色分页查询失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }
    }

    @ApiOperation(value = "获取角色列表", notes = "获取角色列表：查询所有角色")
    @RequestMapping(value = "/findAll", method = RequestMethod.GET)
    public ServerResponse< List<Role> > findAll() throws Exception{
        try {
            List<Role> list= roleService.findAll();
            return ServerResponse.success(list);
        }catch (MyException myException) {
            throw myException;
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("获取角色列表失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }
    }

    @ApiOperation(value = "修改角色的权限组合", notes = "修改角色的权限组合")
    @RequestMapping(value = "/update", method = RequestMethod.PUT)
    public ServerResponse<String> update(@RequestBody Role role) throws Exception{
        try {
            roleService.update(role);
        }catch (MyException myException) {
            throw myException;
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("修改角色的权限组合失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }
        return ServerResponse.success("修改成功。");
    }


}
